/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.HazelcastPhysicalScan;
import com.hazelcast.jet.sql.impl.opt.FullScan;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.cost.CostUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.List;
import javax.annotation.Nullable;

public class FullScanPhysicalRel
extends FullScan
implements HazelcastPhysicalScan {
    FullScanPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider, int watermarkedColumnIndex) {
        super(cluster, traitSet, table, eventTimePolicyProvider, watermarkedColumnIndex);
    }

    @Override
    public Expression<Boolean> filter(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema schema = OptUtils.schema(this.getTable());
        RexNode filter = this.getTable().unwrap(HazelcastTable.class).getFilter();
        return this.filter((PlanNodeFieldTypeProvider)schema, filter, parameterMetadata);
    }

    @Override
    public List<Expression<?>> projection(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema schema = OptUtils.schema(this.getTable());
        HazelcastTable table = this.getTable().unwrap(HazelcastTable.class);
        return this.project((PlanNodeFieldTypeProvider)schema, table.getProjects(), parameterMetadata);
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        List fieldTypes = Util.toList(this.projection(parameterMetadata), Expression::getType);
        return new PlanNodeSchema(fieldTypes);
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onFullScan(this);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double totalRowCount;
        HazelcastTable table = this.getTable().unwrap(HazelcastTable.class);
        double filterRowCount = totalRowCount = table.getStatistic().getRowCount() != null ? table.getTotalRowCount() : this.getTable().getRowCount();
        if (table.getFilter() != null) {
            filterRowCount = CostUtils.adjustFilteredRowCount(totalRowCount, RelMdUtil.guessSelectivity(table.getFilter()));
        }
        return FullScanPhysicalRel.computeSelfCost(planner, totalRowCount, table.getFilter() != null, filterRowCount, table.getProjects().size());
    }

    private static RelOptCost computeSelfCost(RelOptPlanner planner, double scanRowCount, boolean hasFilter, double filterRowCount, int projectCount) {
        double scanCpu = scanRowCount * 1.0;
        double filterCpu = hasFilter ? CostUtils.adjustCpuForConstrainedScan(scanCpu) : 0.0;
        double projectCpu = CostUtils.adjustCpuForConstrainedScan(CostUtils.getProjectCpu(filterRowCount, projectCount));
        return planner.getCostFactory().makeCost(filterRowCount, scanCpu + filterCpu + projectCpu, 0.0);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new FullScanPhysicalRel(this.getCluster(), traitSet, this.getTable(), this.eventTimePolicyProvider(), this.watermarkedColumnIndex());
    }
}

