/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical.index;

import com.hazelcast.com.google.common.collect.BoundType;
import com.hazelcast.com.google.common.collect.Iterables;
import com.hazelcast.com.google.common.collect.Range;
import com.hazelcast.com.google.common.collect.RangeSet;
import com.hazelcast.config.IndexType;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexComponentCandidate;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexComponentFilter;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexComponentFilterResolver;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexRexVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.index.RelCollationComparator;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpression;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.query.impl.ComparableIdentifiedDataSerializable;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.exec.scan.index.IndexCompositeFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class IndexResolver {
    private IndexResolver() {
    }

    public static Collection<RelNode> createIndexScans(FullScanLogicalRel scan, List<MapTableIndex> indexes) {
        RexNode filter = OptUtils.extractHazelcastTable(scan).getFilter();
        ArrayList<MapTableIndex> supportedIndexes = new ArrayList<MapTableIndex>(indexes.size());
        HashSet<Integer> allIndexedFieldOrdinals = new HashSet<Integer>();
        for (MapTableIndex mapTableIndex : indexes) {
            if (!IndexResolver.isIndexSupported(mapTableIndex)) continue;
            supportedIndexes.add(mapTableIndex);
            allIndexedFieldOrdinals.addAll(mapTableIndex.getFieldOrdinals());
        }
        if (supportedIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RelNode> fullScanRels = new ArrayList<RelNode>(supportedIndexes.size());
        for (MapTableIndex index : supportedIndexes) {
            List<Boolean> ascs;
            RelNode relAscending;
            if (index.getType() != IndexType.SORTED || (relAscending = IndexResolver.createFullIndexScan(scan, index, ascs = IndexResolver.buildFieldDirections(index, true), true)) == null) continue;
            fullScanRels.add(relAscending);
            RelNode relDescending = IndexResolver.replaceCollationDirection(relAscending, RelFieldCollation.Direction.DESCENDING);
            fullScanRels.add(relDescending);
        }
        Map<RelCollation, RelNode> map = IndexResolver.excludeCoveredCollations(fullScanRels);
        if (filter == null) {
            return map.values();
        }
        List<RexNode> conjunctions = IndexResolver.createConjunctiveFilter(filter);
        Map<Integer, List<IndexComponentCandidate>> candidates = IndexResolver.prepareSingleColumnCandidates(conjunctions, OptUtils.getCluster(scan).getParameterMetadata(), allIndexedFieldOrdinals);
        if (candidates.isEmpty()) {
            return map.values();
        }
        ArrayList<RelNode> rels = new ArrayList<RelNode>(supportedIndexes.size());
        for (MapTableIndex index : supportedIndexes) {
            List<Boolean> ascs;
            RelNode relAscending = IndexResolver.createIndexScan(scan, index, conjunctions, candidates, ascs = IndexResolver.buildFieldDirections(index, true));
            if (relAscending == null) continue;
            RelCollation relAscCollation = IndexResolver.getCollation(relAscending);
            map.remove(relAscCollation);
            rels.add(relAscending);
            if (relAscCollation.getFieldCollations().size() <= 0) continue;
            RelNode relDescending = IndexResolver.replaceCollationDirection(relAscending, RelFieldCollation.Direction.DESCENDING);
            rels.add(relDescending);
            RelCollation relDescCollation = IndexResolver.getCollation(relDescending);
            map.remove(relDescCollation);
        }
        rels.addAll(map.values());
        return rels;
    }

    private static RelCollation getCollation(RelNode rel) {
        return rel.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE);
    }

    private static RelNode replaceCollationDirection(RelNode rel, RelFieldCollation.Direction direction) {
        RelCollation collation = rel.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE);
        ArrayList<RelFieldCollation> newFields = new ArrayList<RelFieldCollation>(collation.getFieldCollations().size());
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            RelFieldCollation newFieldCollation = new RelFieldCollation(fieldCollation.getFieldIndex(), direction);
            newFields.add(newFieldCollation);
        }
        RelCollation newCollation = RelCollations.of(newFields);
        RelTraitSet traitSet = rel.getTraitSet();
        traitSet = OptUtils.traitPlus(traitSet, newCollation);
        return rel.copy(traitSet, rel.getInputs());
    }

    private static Map<RelCollation, RelNode> excludeCoveredCollations(List<RelNode> rels) {
        TreeMap<RelCollation, RelNode> relsTreeMap = new TreeMap<RelCollation, RelNode>(RelCollationComparator.INSTANCE);
        for (RelNode rel : rels) {
            relsTreeMap.put(rel.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE), rel);
        }
        HashMap<RelCollation, RelNode> resultMap = new HashMap<RelCollation, RelNode>();
        Map.Entry prevEntry = null;
        for (Map.Entry entry : relsTreeMap.descendingMap().entrySet()) {
            RelCollation collation = (RelCollation)entry.getKey();
            RelNode relNode = (RelNode)entry.getValue();
            if (prevEntry == null) {
                resultMap.put(collation, relNode);
                prevEntry = entry;
                continue;
            }
            RelCollation prevCollation = (RelCollation)prevEntry.getKey();
            if (prevCollation.satisfies(collation)) continue;
            prevEntry = entry;
            resultMap.put(collation, relNode);
        }
        return resultMap;
    }

    private static List<RexNode> createConjunctiveFilter(RexNode filter) {
        ArrayList<RexNode> conjunctions = new ArrayList<RexNode>(1);
        RelOptUtil.decomposeConjunction(filter, conjunctions);
        return conjunctions;
    }

    private static Map<Integer, List<IndexComponentCandidate>> prepareSingleColumnCandidates(List<RexNode> expressions, QueryParameterMetadata parameterMetadata, Set<Integer> allIndexedFieldOrdinals) {
        HashMap<Integer, List<IndexComponentCandidate>> res = new HashMap<Integer, List<IndexComponentCandidate>>();
        for (RexNode expression : expressions) {
            IndexComponentCandidate candidate = IndexResolver.prepareSingleColumnCandidate(expression, parameterMetadata);
            if (candidate == null || !allIndexedFieldOrdinals.contains(candidate.getColumnIndex())) continue;
            res.computeIfAbsent(candidate.getColumnIndex(), k -> new ArrayList()).add(candidate);
        }
        return res;
    }

    private static IndexComponentCandidate prepareSingleColumnCandidate(RexNode exp, QueryParameterMetadata parameterMetadata) {
        SqlKind kind = exp.getKind();
        switch (kind) {
            case IS_TRUE: 
            case IS_FALSE: 
            case IS_NOT_TRUE: 
            case IS_NOT_FALSE: {
                return IndexResolver.prepareSingleColumnCandidateBooleanIsTrueFalse(exp, IndexResolver.removeCastIfPossible(((RexCall)exp).getOperands().get(0)), kind);
            }
            case INPUT_REF: {
                return IndexResolver.prepareSingleColumnCandidateBooleanIsTrueFalse(exp, exp, SqlKind.IS_TRUE);
            }
            case NOT: {
                return IndexResolver.prepareSingleColumnCandidateBooleanIsTrueFalse(exp, IndexResolver.removeCastIfPossible(((RexCall)exp).getOperands().get(0)), SqlKind.IS_FALSE);
            }
            case IS_NULL: {
                return IndexResolver.prepareSingleColumnCandidateIsNull(exp, IndexResolver.removeCastIfPossible(((RexCall)exp).getOperands().get(0)));
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case EQUALS: {
                BiTuple<RexNode, RexNode> operands = IndexResolver.extractComparisonOperands(exp);
                return IndexResolver.prepareSingleColumnCandidateComparison(exp, kind, (RexNode)operands.element1(), (RexNode)operands.element2(), parameterMetadata);
            }
            case SEARCH: {
                BiTuple<RexNode, RexNode> operands = IndexResolver.extractComparisonOperands(exp);
                return IndexResolver.prepareSingleColumnSearchCandidateComparison(exp, (RexNode)operands.element1(), (RexNode)operands.element2());
            }
            case OR: {
                return IndexResolver.prepareSingleColumnCandidateOr(exp, ((RexCall)exp).getOperands(), parameterMetadata);
            }
        }
        return null;
    }

    private static IndexComponentCandidate prepareSingleColumnCandidateBooleanIsTrueFalse(RexNode exp, RexNode operand, SqlKind kind) {
        IndexEqualsFilter filter;
        if (operand.getKind() != SqlKind.INPUT_REF) {
            return null;
        }
        if (operand.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
            return null;
        }
        int columnIndex = ((RexInputRef)operand).getIndex();
        switch (kind) {
            case IS_TRUE: {
                filter = new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(false)));
                break;
            }
            case IS_FALSE: {
                filter = new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create((Object)false, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(false)));
                break;
            }
            case IS_NOT_TRUE: {
                filter = new IndexCompositeFilter(new IndexFilter[]{new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create((Object)false, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(false))), new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create(null, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(true)))});
                break;
            }
            default: {
                assert (kind == SqlKind.IS_NOT_FALSE);
                filter = new IndexCompositeFilter(new IndexFilter[]{new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(false))), new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create(null, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(true)))});
            }
        }
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)filter);
    }

    private static IndexComponentCandidate prepareSingleColumnCandidateIsNull(RexNode exp, RexNode operand) {
        if (operand.getKind() != SqlKind.INPUT_REF) {
            return null;
        }
        int columnIndex = ((RexInputRef)operand).getIndex();
        QueryDataType type = HazelcastTypeUtils.toHazelcastType(operand.getType());
        IndexFilterValue filterValue = new IndexFilterValue(Collections.singletonList(ConstantExpression.create(null, (QueryDataType)type)), Collections.singletonList(true));
        IndexEqualsFilter filter = new IndexEqualsFilter(filterValue);
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)filter);
    }

    private static IndexComponentCandidate prepareSingleColumnCandidateComparison(RexNode exp, SqlKind kind, RexNode operand1, RexNode operand2, QueryParameterMetadata parameterMetadata) {
        IndexEqualsFilter filter;
        if (operand1.getKind() != SqlKind.INPUT_REF && operand2.getKind() == SqlKind.INPUT_REF) {
            kind = IndexResolver.inverseIndexConditionKind(kind);
            RexNode tmp = operand1;
            operand1 = operand2;
            operand2 = tmp;
        }
        if (operand1.getKind() != SqlKind.INPUT_REF) {
            return null;
        }
        int columnIndex = ((RexInputRef)operand1).getIndex();
        if (!IndexRexVisitor.isValid(operand2)) {
            return null;
        }
        Expression<?> filterValue = IndexResolver.convertToExpression(operand2, parameterMetadata);
        if (filterValue == null) {
            return null;
        }
        IndexFilterValue filterValue0 = new IndexFilterValue(Collections.singletonList(filterValue), Collections.singletonList(false));
        switch (kind) {
            case EQUALS: {
                filter = new IndexEqualsFilter(filterValue0);
                break;
            }
            case GREATER_THAN: {
                filter = new IndexRangeFilter(filterValue0, false, null, false);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filter = new IndexRangeFilter(filterValue0, true, null, false);
                break;
            }
            case LESS_THAN: {
                filter = new IndexRangeFilter(null, false, filterValue0, false);
                break;
            }
            default: {
                assert (kind == SqlKind.LESS_THAN_OR_EQUAL);
                filter = new IndexRangeFilter(null, false, filterValue0, true);
            }
        }
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)filter);
    }

    private static IndexComponentCandidate prepareSingleColumnSearchCandidateComparison(RexNode exp, RexNode operand1, RexNode operand2) {
        if (operand1.getKind() != SqlKind.INPUT_REF || operand2.getKind() != SqlKind.LITERAL) {
            return null;
        }
        int columnIndex = ((RexInputRef)operand1).getIndex();
        RexLiteral literal = (RexLiteral)operand2;
        QueryDataType hazelcastType = HazelcastTypeUtils.toHazelcastType(literal.getType());
        RangeSet rangeSet = RexToExpression.extractRangeFromSearch(literal);
        if (rangeSet == null) {
            return null;
        }
        Set ranges = rangeSet.asRanges();
        Object indexFilter = ranges.size() == 1 ? IndexResolver.createIndexFilterForSingleRange(Iterables.getFirst(ranges, null), hazelcastType) : new IndexCompositeFilter(Util.toList(ranges, range -> IndexResolver.createIndexFilterForSingleRange(range, hazelcastType)));
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)indexFilter);
    }

    @Nonnull
    private static IndexFilter createIndexFilterForSingleRange(Range<?> range, QueryDataType hazelcastType) {
        IndexFilterValue lowerBound0 = null;
        if (range.hasLowerBound()) {
            ConstantExpression lowerBound = ConstantExpression.create(range.lowerEndpoint(), (QueryDataType)hazelcastType);
            lowerBound0 = new IndexFilterValue(Collections.singletonList(lowerBound), Collections.singletonList(false));
            if (IndexResolver.isSingletonRange(range)) {
                return new IndexEqualsFilter(lowerBound0);
            }
        }
        if (range.hasUpperBound()) {
            ConstantExpression upperBound = ConstantExpression.create(range.upperEndpoint(), (QueryDataType)hazelcastType);
            IndexFilterValue upperBound0 = new IndexFilterValue(Collections.singletonList(upperBound), Collections.singletonList(false));
            if (lowerBound0 == null) {
                return new IndexRangeFilter(null, false, upperBound0, range.upperBoundType() == BoundType.CLOSED);
            }
            return new IndexRangeFilter(lowerBound0, range.lowerBoundType() == BoundType.CLOSED, upperBound0, range.upperBoundType() == BoundType.CLOSED);
        }
        assert (lowerBound0 != null);
        return new IndexRangeFilter(lowerBound0, range.lowerBoundType() == BoundType.CLOSED, null, false);
    }

    private static <T extends Comparable<T>> boolean isSingletonRange(Range<T> range) {
        return range.hasLowerBound() && range.hasUpperBound() && range.lowerBoundType() == BoundType.CLOSED && range.upperBoundType() == BoundType.CLOSED && range.lowerEndpoint().compareTo(range.upperEndpoint()) == 0;
    }

    private static Expression<?> convertToExpression(RexNode operand, QueryParameterMetadata parameterMetadata) {
        try {
            RexToExpressionVisitor visitor = new RexToExpressionVisitor(PlanNodeFieldTypeProvider.FAILING_FIELD_TYPE_PROVIDER, parameterMetadata);
            return (Expression)operand.accept(visitor);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static IndexComponentCandidate prepareSingleColumnCandidateOr(RexNode exp, List<RexNode> nodes, QueryParameterMetadata parameterMetadata) {
        Integer columnIndex = null;
        ArrayList<IndexFilter> filters = new ArrayList<IndexFilter>();
        for (RexNode node : nodes) {
            IndexComponentCandidate candidate = IndexResolver.prepareSingleColumnCandidate(node, parameterMetadata);
            if (candidate == null) {
                return null;
            }
            IndexFilter candidateFilter = candidate.getFilter();
            if (!(candidateFilter instanceof IndexEqualsFilter) && !(candidateFilter instanceof IndexCompositeFilter)) {
                return null;
            }
            if (columnIndex == null) {
                columnIndex = candidate.getColumnIndex();
            } else if (columnIndex.intValue() != candidate.getColumnIndex()) {
                return null;
            }
            if (candidateFilter instanceof IndexEqualsFilter) {
                filters.add(candidateFilter);
                continue;
            }
            filters.addAll(((IndexCompositeFilter)candidateFilter).getFilters());
        }
        assert (columnIndex != null);
        IndexCompositeFilter inFilter = new IndexCompositeFilter(filters);
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)inFilter);
    }

    public static RelNode createIndexScan(FullScanLogicalRel scan, MapTableIndex index, List<RexNode> conjunctions, Map<Integer, List<IndexComponentCandidate>> candidates, List<Boolean> ascs) {
        ArrayList<IndexComponentFilter> filters = new ArrayList<IndexComponentFilter>(index.getFieldOrdinals().size());
        for (int i = 0; i < index.getFieldOrdinals().size(); ++i) {
            IndexComponentFilter filter;
            int fieldOrdinal = (Integer)index.getFieldOrdinals().get(i);
            QueryDataType fieldConverterType = (QueryDataType)index.getFieldConverterTypes().get(i);
            List<IndexComponentCandidate> fieldCandidates = candidates.get(fieldOrdinal);
            if (fieldCandidates == null || (filter = IndexComponentFilterResolver.findBestComponentFilter(index.getType(), fieldCandidates, fieldConverterType)) == null) break;
            filters.add(filter);
            if (!(filter.getFilter() instanceof IndexEqualsFilter)) break;
        }
        if (filters.isEmpty()) {
            return null;
        }
        return IndexResolver.createIndexScan(scan, index, conjunctions, filters, ascs);
    }

    private static IndexScanMapPhysicalRel createIndexScan(FullScanLogicalRel scan, MapTableIndex index, List<RexNode> conjunctions, List<IndexComponentFilter> filterDescriptors, List<Boolean> ascs) {
        ArrayList<IndexFilter> filters = new ArrayList<IndexFilter>(filterDescriptors.size());
        HashSet<RexNode> exps = new HashSet<RexNode>();
        for (IndexComponentFilter filterDescriptor : filterDescriptors) {
            filters.add(filterDescriptor.getFilter());
            exps.addAll(filterDescriptor.getExpressions());
        }
        RexBuilder rexBuilder = scan.getCluster().getRexBuilder();
        RexNode exp = RexUtil.composeConjunction(rexBuilder, exps);
        List<RexNode> remainderConjunctiveExps = IndexResolver.excludeNodes(conjunctions, exps);
        RexNode remainderExp = remainderConjunctiveExps.isEmpty() ? null : RexUtil.composeConjunction(rexBuilder, remainderConjunctiveExps);
        RelTraitSet traitSet = scan.getTraitSet();
        RelCollation relCollation = IndexResolver.buildCollationTrait(scan, index, ascs);
        traitSet = OptUtils.traitPlus(traitSet, relCollation);
        HazelcastRelOptTable originalRelTable = (HazelcastRelOptTable)scan.getTable();
        HazelcastTable originalHazelcastTable = OptUtils.extractHazelcastTable(scan);
        HazelcastRelOptTable newRelTable = OptUtils.createRelTable(originalRelTable, originalHazelcastTable.withFilter(null), scan.getCluster().getTypeFactory());
        IndexFilter filter = IndexResolver.composeFilter(filters, index.getType(), index.getComponentsCount());
        if (filter == null) {
            return null;
        }
        return new IndexScanMapPhysicalRel(scan.getCluster(), OptUtils.toPhysicalConvention(traitSet), newRelTable, index, filter, exp, remainderExp);
    }

    private static RelCollation buildCollationTrait(FullScanLogicalRel scan, MapTableIndex index, List<Boolean> ascs) {
        Integer indexFieldOrdinal;
        int remappedIndexFieldOrdinal;
        if (index.getType() != IndexType.SORTED) {
            return RelCollations.of(Collections.emptyList());
        }
        ArrayList<RelFieldCollation> fields = new ArrayList<RelFieldCollation>(index.getFieldOrdinals().size());
        HazelcastTable table = OptUtils.extractHazelcastTable(scan);
        List fieldProjects = table.getProjects().stream().filter(expr -> expr instanceof RexInputRef).map(inputRef -> ((RexInputRef)inputRef).getIndex()).collect(Collectors.toList());
        for (int i = 0; i < index.getFieldOrdinals().size() && (remappedIndexFieldOrdinal = fieldProjects.indexOf(indexFieldOrdinal = (Integer)index.getFieldOrdinals().get(i))) != -1; ++i) {
            RelFieldCollation.Direction direction = ascs.get(i) != false ? RelFieldCollation.Direction.ASCENDING : RelFieldCollation.Direction.DESCENDING;
            RelFieldCollation fieldCollation = new RelFieldCollation(remappedIndexFieldOrdinal, direction);
            fields.add(fieldCollation);
        }
        return RelCollations.of(fields);
    }

    private static List<Boolean> buildFieldDirections(MapTableIndex index, boolean allAscending) {
        ArrayList<Boolean> ascs = new ArrayList<Boolean>(index.getFieldOrdinals().size());
        for (int i = 0; i < index.getFieldOrdinals().size(); ++i) {
            Boolean asc = allAscending ? Boolean.TRUE : Boolean.FALSE;
            ascs.add(asc);
        }
        return ascs;
    }

    private static RelNode createFullIndexScan(FullScanLogicalRel scan, MapTableIndex index, List<Boolean> ascs, boolean nonEmptyCollation) {
        assert (IndexResolver.isIndexSupported(index));
        RexNode scanFilter = OptUtils.extractHazelcastTable(scan).getFilter();
        RelTraitSet traitSet = OptUtils.toPhysicalConvention(scan.getTraitSet());
        RelCollation relCollation = IndexResolver.buildCollationTrait(scan, index, ascs);
        if (nonEmptyCollation && relCollation.getFieldCollations().size() == 0) {
            return null;
        }
        traitSet = OptUtils.traitPlus(traitSet, relCollation);
        HazelcastRelOptTable originalRelTable = (HazelcastRelOptTable)scan.getTable();
        HazelcastTable originalHazelcastTable = OptUtils.extractHazelcastTable(scan);
        HazelcastRelOptTable newRelTable = OptUtils.createRelTable(originalRelTable.getDelegate().getQualifiedName(), originalHazelcastTable.withFilter(null), scan.getCluster().getTypeFactory());
        return new IndexScanMapPhysicalRel(scan.getCluster(), traitSet, newRelTable, index, null, null, scanFilter);
    }

    private static IndexFilter composeFilter(List<IndexFilter> filters, IndexType indexType, int indexComponentsCount) {
        assert (!filters.isEmpty());
        if (indexComponentsCount == 1) {
            assert (filters.size() == 1);
            IndexFilter res = filters.get(0);
            assert (!(res instanceof IndexRangeFilter) || indexType == IndexType.SORTED);
            return res;
        }
        IndexFilter lastFilter = filters.get(filters.size() - 1);
        if (lastFilter instanceof IndexEqualsFilter) {
            return IndexResolver.composeEqualsFilter(filters, (IndexEqualsFilter)lastFilter, indexType, indexComponentsCount);
        }
        if (lastFilter instanceof IndexCompositeFilter) {
            return IndexResolver.composeCompositeFilter(filters, (IndexCompositeFilter)lastFilter, indexType, indexComponentsCount);
        }
        assert (lastFilter instanceof IndexRangeFilter);
        assert (indexType == IndexType.SORTED);
        return IndexResolver.composeRangeFilter(filters, (IndexRangeFilter)lastFilter, indexType, indexComponentsCount);
    }

    private static IndexFilter composeEqualsFilter(List<IndexFilter> filters, IndexEqualsFilter lastFilter, IndexType indexType, int indexComponentsCount) {
        ArrayList<Expression> components = new ArrayList<Expression>(filters.size());
        ArrayList<Boolean> allowNulls = new ArrayList<Boolean>(filters.size());
        IndexResolver.fillNonTerminalComponents(filters, components, allowNulls);
        components.addAll(lastFilter.getValue().getComponents());
        allowNulls.addAll(lastFilter.getValue().getAllowNulls());
        if (indexComponentsCount == components.size()) {
            return new IndexEqualsFilter(new IndexFilterValue(components, allowNulls));
        }
        if (indexType == IndexType.HASH) {
            return null;
        }
        ArrayList<Expression> fromComponents = components;
        ArrayList<Expression> toComponents = new ArrayList<Expression>(components);
        ArrayList<Boolean> fromAllowNulls = allowNulls;
        ArrayList<Boolean> toAllowNulls = new ArrayList<Boolean>(fromAllowNulls);
        IndexResolver.addInfiniteRanges(fromComponents, fromAllowNulls, true, toComponents, toAllowNulls, true, indexComponentsCount);
        return new IndexRangeFilter(new IndexFilterValue(fromComponents, fromAllowNulls), true, new IndexFilterValue(toComponents, toAllowNulls), true);
    }

    private static IndexFilter composeCompositeFilter(List<IndexFilter> filters, IndexCompositeFilter lastFilter, IndexType indexType, int indexComponentsCount) {
        ArrayList<IndexFilter> newFilters = new ArrayList<IndexFilter>(lastFilter.getFilters().size());
        for (IndexFilter filter : lastFilter.getFilters()) {
            IndexFilter newFilter;
            if (filter instanceof IndexEqualsFilter) {
                newFilter = IndexResolver.composeEqualsFilter(filters, (IndexEqualsFilter)filter, indexType, indexComponentsCount);
                if (newFilter == null) {
                    return null;
                }
                newFilters.add(newFilter);
                continue;
            }
            if (!(filter instanceof IndexRangeFilter)) continue;
            newFilter = IndexResolver.composeRangeFilter(filters, (IndexRangeFilter)filter, indexType, indexComponentsCount);
            newFilters.add(newFilter);
        }
        return new IndexCompositeFilter(newFilters);
    }

    private static IndexFilter composeRangeFilter(List<IndexFilter> filters, IndexRangeFilter lastFilter, IndexType indexType, int componentsCount) {
        if (indexType == IndexType.HASH) {
            return null;
        }
        ArrayList<Expression> components = new ArrayList<Expression>(filters.size());
        ArrayList<Boolean> allowNulls = new ArrayList<Boolean>();
        IndexResolver.fillNonTerminalComponents(filters, components, allowNulls);
        ArrayList<Expression> fromComponents = components;
        ArrayList<Expression> toComponents = new ArrayList<Expression>(components);
        ArrayList<Boolean> fromAllowNulls = allowNulls;
        ArrayList<Boolean> toAllowNulls = new ArrayList<Boolean>(fromAllowNulls);
        if (lastFilter.getFrom() != null) {
            fromComponents.add((Expression)lastFilter.getFrom().getComponents().get(0));
            fromAllowNulls.add(false);
        } else if (componentsCount == 1) {
            fromComponents.add((Expression)ConstantExpression.create((Object)CompositeValue.NEGATIVE_INFINITY, (QueryDataType)QueryDataType.OBJECT));
            fromAllowNulls.add(false);
        } else {
            fromComponents.add((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.OBJECT));
            fromAllowNulls.add(true);
        }
        if (lastFilter.getTo() != null) {
            toComponents.add((Expression)lastFilter.getTo().getComponents().get(0));
        } else {
            toComponents.add((Expression)ConstantExpression.create((Object)CompositeValue.POSITIVE_INFINITY, (QueryDataType)QueryDataType.OBJECT));
        }
        toAllowNulls.add(false);
        IndexResolver.addInfiniteRanges(fromComponents, fromAllowNulls, lastFilter.isFromInclusive(), toComponents, toAllowNulls, lastFilter.isToInclusive(), componentsCount);
        return new IndexRangeFilter(new IndexFilterValue(fromComponents, fromAllowNulls), lastFilter.isFromInclusive(), new IndexFilterValue(toComponents, toAllowNulls), lastFilter.isToInclusive());
    }

    private static void fillNonTerminalComponents(List<IndexFilter> filters, List<Expression> components, List<Boolean> allowNulls) {
        for (int i = 0; i < filters.size() - 1; ++i) {
            IndexEqualsFilter filter0 = (IndexEqualsFilter)filters.get(i);
            IndexFilterValue value = filter0.getValue();
            assert (value.getComponents().size() == 1);
            components.add((Expression)value.getComponents().get(0));
            allowNulls.add((Boolean)value.getAllowNulls().get(0));
        }
        assert (components.size() == filters.size() - 1);
        assert (allowNulls.size() == filters.size() - 1);
    }

    private static void addInfiniteRanges(List<Expression> fromComponents, List<Boolean> fromAllowNulls, boolean fromInclusive, List<Expression> toComponents, List<Boolean> toAllowNulls, boolean toInclusive, int componentsCount) {
        int count = componentsCount - fromComponents.size();
        ComparableIdentifiedDataSerializable leftBound = fromInclusive ? CompositeValue.NEGATIVE_INFINITY : CompositeValue.POSITIVE_INFINITY;
        ComparableIdentifiedDataSerializable toBound = toInclusive ? CompositeValue.POSITIVE_INFINITY : CompositeValue.NEGATIVE_INFINITY;
        for (int i = 0; i < count; ++i) {
            fromComponents.add((Expression)ConstantExpression.create((Object)leftBound, (QueryDataType)QueryDataType.OBJECT));
            toComponents.add((Expression)ConstantExpression.create((Object)toBound, (QueryDataType)QueryDataType.OBJECT));
            fromAllowNulls.add(false);
            toAllowNulls.add(false);
        }
    }

    private static SqlKind inverseIndexConditionKind(SqlKind kind) {
        switch (kind) {
            case GREATER_THAN: {
                return SqlKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
        }
        assert (kind == SqlKind.EQUALS);
        return kind;
    }

    private static boolean isIndexSupported(MapTableIndex index) {
        return index.getType() == IndexType.SORTED || index.getType() == IndexType.HASH;
    }

    private static BiTuple<RexNode, RexNode> extractComparisonOperands(RexNode node) {
        assert (node instanceof RexCall);
        RexCall node0 = (RexCall)node;
        assert (node0.getOperands().size() == 2);
        RexNode operand1 = node0.getOperands().get(0);
        RexNode operand2 = node0.getOperands().get(1);
        RexNode normalizedOperand1 = IndexResolver.removeCastIfPossible(operand1);
        RexNode normalizedOperand2 = IndexResolver.removeCastIfPossible(operand2);
        return BiTuple.of((Object)normalizedOperand1, (Object)normalizedOperand2);
    }

    private static RexNode removeCastIfPossible(RexNode node) {
        RexCall node0;
        RexNode from;
        if (node.getKind() == SqlKind.CAST && (from = (node0 = (RexCall)node).getOperands().get(0)) instanceof RexInputRef) {
            RelDataType toType;
            RelDataType fromType = from.getType();
            if (fromType.equals(toType = node0.getType())) {
                return from;
            }
            QueryDataTypeFamily fromFamily = HazelcastTypeUtils.toHazelcastType(fromType).getTypeFamily();
            QueryDataTypeFamily toFamily = HazelcastTypeUtils.toHazelcastType(toType).getTypeFamily();
            if (QueryDataTypeUtils.isNumeric((QueryDataTypeFamily)fromFamily) && QueryDataTypeUtils.isNumeric((QueryDataTypeFamily)toFamily) && toFamily.getPrecedence() > fromFamily.getPrecedence()) {
                return from;
            }
        }
        return node;
    }

    private static List<RexNode> excludeNodes(Collection<RexNode> nodes, Set<RexNode> exclusions) {
        ArrayList<RexNode> res = new ArrayList<RexNode>(nodes.size());
        for (RexNode node : nodes) {
            if (exclusions.contains(node)) continue;
            res.add(node);
        }
        return res;
    }
}

