/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.infoschema.MappingColumnsTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.MappingsTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.TablesTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.ViewsTable;
import com.hazelcast.jet.sql.impl.connector.virtual.ViewTable;
import com.hazelcast.jet.sql.impl.schema.TablesStorage;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.view.View;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TableResolverImpl
implements TableResolver {
    public static final String SCHEMA_NAME_PUBLIC = "public";
    public static final String SCHEMA_NAME_INFORMATION_SCHEMA = "information_schema";
    private static final List<List<String>> SEARCH_PATHS = Collections.singletonList(Arrays.asList("hazelcast", "public"));
    private final NodeEngine nodeEngine;
    private final TablesStorage tableStorage;
    private final SqlConnectorCache connectorCache;
    private final List<TableResolver.TableListener> listeners;

    public TableResolverImpl(NodeEngine nodeEngine, TablesStorage tableStorage, SqlConnectorCache connectorCache) {
        this.nodeEngine = nodeEngine;
        this.tableStorage = tableStorage;
        this.connectorCache = connectorCache;
        this.listeners = new CopyOnWriteArrayList<TableResolver.TableListener>();
        nodeEngine.getHazelcastInstance().getLifecycleService().addLifecycleListener(event -> {
            if (event.getState() == LifecycleEvent.LifecycleState.STARTED) {
                this.tableStorage.registerListener(new TablesStorage.EntryListenerAdapter(){

                    @Override
                    public void entryUpdated(EntryEvent<String, Object> event) {
                        if (!event.getMember().localMember()) {
                            TableResolverImpl.this.listeners.forEach(TableResolver.TableListener::onTableChanged);
                        }
                    }

                    @Override
                    public void entryRemoved(EntryEvent<String, Object> event) {
                        if (!event.getMember().localMember()) {
                            TableResolverImpl.this.listeners.forEach(TableResolver.TableListener::onTableChanged);
                        }
                    }
                });
            }
        });
    }

    public void createMapping(Mapping mapping, boolean replace, boolean ifNotExists) {
        Mapping resolved = this.resolveMapping(mapping);
        String name = resolved.name();
        if (ifNotExists) {
            this.tableStorage.putIfAbsent(name, resolved);
        } else if (replace) {
            this.tableStorage.put(name, resolved);
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
        } else if (!this.tableStorage.putIfAbsent(name, resolved)) {
            throw QueryException.error((String)("Mapping or view already exists: " + name));
        }
    }

    private Mapping resolveMapping(Mapping mapping) {
        String type = mapping.type();
        Map options = mapping.options();
        SqlConnector connector = this.connectorCache.forType(type);
        List<MappingField> resolvedFields = connector.resolveAndValidateFields(this.nodeEngine, options, mapping.fields());
        return new Mapping(mapping.name(), mapping.externalName(), type, new ArrayList<MappingField>(resolvedFields), new LinkedHashMap(options));
    }

    public void removeMapping(String name, boolean ifExists) {
        if (this.tableStorage.removeMapping(name) != null) {
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
        } else if (!ifExists) {
            throw QueryException.error((String)("Mapping does not exist: " + name));
        }
    }

    @Nonnull
    public Collection<String> getMappingNames() {
        return this.tableStorage.mappingNames();
    }

    public void createView(View view, boolean replace, boolean ifNotExists) {
        if (ifNotExists) {
            this.tableStorage.putIfAbsent(view.name(), view);
        } else if (replace) {
            this.tableStorage.put(view.name(), view);
        } else if (!this.tableStorage.putIfAbsent(view.name(), view)) {
            throw QueryException.error((String)("Mapping or view already exists: " + view.name()));
        }
    }

    public View getView(String name) {
        return this.tableStorage.getView(name);
    }

    public void removeView(String name, boolean ifExists) {
        if (this.tableStorage.removeView(name) == null && !ifExists) {
            throw QueryException.error((String)("View does not exist: " + name));
        }
    }

    @Nonnull
    public Collection<String> getViewNames() {
        return this.tableStorage.viewNames();
    }

    @Nonnull
    public List<List<String>> getDefaultSearchPaths() {
        return SEARCH_PATHS;
    }

    @Nonnull
    public List<Table> getTables() {
        Collection<Object> objects = this.tableStorage.allObjects();
        ArrayList<Table> tables = new ArrayList<Table>(objects.size() + 3);
        for (Object o2 : objects) {
            if (o2 instanceof Mapping) {
                tables.add(this.toTable((Mapping)o2));
                continue;
            }
            if (o2 instanceof View) {
                tables.add(this.toTable((View)o2));
                continue;
            }
            throw new RuntimeException("Unexpected: " + o2);
        }
        Collection mappings = objects.stream().filter(o -> o instanceof Mapping).map(m4 -> (Mapping)m4).collect(Collectors.toList());
        Collection views = objects.stream().filter(o -> o instanceof View).map(v -> (View)v).collect(Collectors.toList());
        tables.add(new TablesTable("hazelcast", SCHEMA_NAME_INFORMATION_SCHEMA, SCHEMA_NAME_PUBLIC, mappings, views));
        tables.add(new MappingsTable("hazelcast", SCHEMA_NAME_INFORMATION_SCHEMA, SCHEMA_NAME_PUBLIC, mappings));
        tables.add(new MappingColumnsTable("hazelcast", SCHEMA_NAME_INFORMATION_SCHEMA, SCHEMA_NAME_PUBLIC, mappings, views));
        tables.add(new ViewsTable("hazelcast", SCHEMA_NAME_INFORMATION_SCHEMA, SCHEMA_NAME_PUBLIC, views));
        return tables;
    }

    private Table toTable(Mapping mapping) {
        SqlConnector connector = this.connectorCache.forType(mapping.type());
        return connector.createTable(this.nodeEngine, SCHEMA_NAME_PUBLIC, mapping.name(), mapping.externalName(), mapping.options(), mapping.fields());
    }

    private Table toTable(View view) {
        ArrayList<TableField> tableFields = new ArrayList<TableField>(view.viewColumnNames().size());
        for (int i = 0; i < view.viewColumnNames().size(); ++i) {
            tableFields.add(new TableField((String)view.viewColumnNames().get(i), (QueryDataType)view.viewColumnTypes().get(i), false));
        }
        return new ViewTable(SCHEMA_NAME_PUBLIC, view, tableFields, (TableStatistics)new ConstantTableStatistics(0L));
    }

    public void registerListener(TableResolver.TableListener listener) {
        this.listeners.add(listener);
    }
}

