/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.jet.sql.impl.aggregate.function.ImposeOrderFunction;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.connector.virtual.ViewTable;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.jet.sql.impl.parse.SqlDropView;
import com.hazelcast.jet.sql.impl.parse.SqlExplainStatement;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableSourceFunction;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlConformance;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.jet.sql.impl.validate.literal.LiteralUtils;
import com.hazelcast.jet.sql.impl.validate.param.AbstractParameterConverter;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeCoercion;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.org.apache.calcite.runtime.ResourceUtil;
import com.hazelcast.org.apache.calcite.runtime.Resources;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlDelete;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.org.apache.calcite.sql.SqlIntervalLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlJoin;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlQualified;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImplBridge;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.IMapResolver;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HazelcastSqlValidator
extends SqlValidatorImplBridge {
    private static final String OBJECT_NOT_FOUND = ResourceUtil.key(Static.RESOURCE.objectNotFound(""));
    private static final String OBJECT_NOT_FOUND_WITHIN = ResourceUtil.key(Static.RESOURCE.objectNotFoundWithin("", ""));
    private static final SqlValidator.Config CONFIG = SqlValidator.Config.DEFAULT.withIdentifierExpansion(true).withSqlConformance(HazelcastSqlConformance.INSTANCE).withTypeCoercionFactory(HazelcastTypeCoercion::new);
    private final HazelcastSqlOperatorTable.RewriteVisitor rewriteVisitor;
    private final Map<Integer, ParameterConverter> parameterConverterMap = new HashMap<Integer, ParameterConverter>();
    private final Map<Integer, SqlParserPos> parameterPositionMap = new HashMap<Integer, SqlParserPos>();
    private final List<Object> arguments;
    private final IMapResolver iMapResolver;
    private boolean isCreateJob;
    private boolean isInfiniteRows;

    public HazelcastSqlValidator(SqlValidatorCatalogReader catalogReader, List<Object> arguments, IMapResolver iMapResolver) {
        super(HazelcastSqlOperatorTable.instance(), catalogReader, HazelcastTypeFactory.INSTANCE, CONFIG);
        this.rewriteVisitor = new HazelcastSqlOperatorTable.RewriteVisitor(this);
        this.arguments = arguments;
        this.iMapResolver = iMapResolver;
    }

    @Override
    public SqlNode validate(SqlNode topNode) {
        if (topNode instanceof SqlCreateJob) {
            this.isCreateJob = true;
        }
        if (topNode instanceof SqlDropView) {
            return topNode;
        }
        if (topNode.getKind().belongsTo(SqlKind.DDL)) {
            topNode.validate(this, this.getEmptyScope());
            return topNode;
        }
        if (topNode instanceof SqlShowStatement) {
            return topNode;
        }
        if (topNode instanceof SqlExplainStatement) {
            SqlExplainStatement explainStatement = (SqlExplainStatement)topNode;
            SqlNode explicandum = explainStatement.getExplicandum();
            explicandum = super.validate(explicandum);
            explainStatement.setExplicandum(explicandum);
            return explainStatement;
        }
        return super.validate(topNode);
    }

    @Override
    public void validateQuery(SqlNode node, SqlValidatorScope scope, RelDataType targetRowType) {
        super.validateQuery(node, scope, targetRowType);
        if (node instanceof SqlSelect) {
            this.validateSelect((SqlSelect)node, scope);
        }
    }

    private void validateSelect(SqlSelect select, SqlValidatorScope scope) {
        SqlNode offset;
        SqlNode fetch = select.getFetch();
        if (fetch != null) {
            this.deriveType(scope, fetch);
            fetch.validate(this, this.getEmptyScope());
        }
        if ((offset = select.getOffset()) != null) {
            this.deriveType(scope, offset);
            offset.validate(this, this.getEmptyScope());
        }
    }

    @Override
    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SelectScope scope, boolean includeSystemVars) {
        if (this.isHiddenColumn(exp, scope)) {
            return;
        }
        super.addToSelectList(list, aliases, fieldList, exp, scope, includeSystemVars);
    }

    @Override
    protected void validateFrom(SqlNode node, RelDataType targetRowType, SqlValidatorScope scope) {
        super.validateFrom(node, targetRowType, scope);
        if (HazelcastSqlValidator.countOrderingFunctions(node) > 1) {
            throw this.newValidationError(node, ValidatorResource.RESOURCE.multipleOrderingFunctionsNotSupported());
        }
        this.isInfiniteRows = this.containsStreamingSource(node);
    }

    private static int countOrderingFunctions(SqlNode node) {
        class OrderingFunctionCounter
        extends SqlBasicVisitor<Void> {
            int count;

            OrderingFunctionCounter() {
            }

            @Override
            public Void visit(SqlCall call) {
                SqlOperator operator = call.getOperator();
                if (operator instanceof ImposeOrderFunction) {
                    ++this.count;
                }
                return (Void)super.visit(call);
            }
        }
        OrderingFunctionCounter counter = new OrderingFunctionCounter();
        node.accept(counter);
        return counter.count;
    }

    @Override
    protected void validateOrderList(SqlSelect select) {
        super.validateOrderList(select);
        if (select.hasOrderBy() && this.isInfiniteRows(select)) {
            throw this.newValidationError(select, ValidatorResource.RESOURCE.streamingSortingNotSupported());
        }
    }

    @Override
    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        super.validateJoin(join, scope);
        boolean leftInputIsStream = this.containsStreamingSource(join.getLeft());
        boolean rightInputIsStream = this.containsStreamingSource(join.getRight());
        if (leftInputIsStream && rightInputIsStream) {
            throw this.newValidationError(join, ValidatorResource.RESOURCE.streamToStreamJoinNotSupported());
        }
        switch (join.getJoinType()) {
            case LEFT: {
                if (!rightInputIsStream) break;
                throw this.newValidationError(join, ValidatorResource.RESOURCE.streamingSourceOnWrongSide("right", "LEFT"));
            }
            case RIGHT: {
                if (!leftInputIsStream) break;
                throw this.newValidationError(join, ValidatorResource.RESOURCE.streamingSourceOnWrongSide("left", "RIGHT"));
            }
            case FULL: {
                throw QueryException.error((int)1008, (String)"FULL join not supported");
            }
            case INNER: 
            case COMMA: 
            case CROSS: {
                if (!rightInputIsStream) break;
                throw this.newValidationError(join, ValidatorResource.RESOURCE.streamingSourceOnWrongSide("right", join.getJoinType().name().toUpperCase()));
            }
            default: {
                throw QueryException.error((int)1008, (String)("Unexpected join type: " + join.getJoinType()));
            }
        }
    }

    @Override
    public void validateInsert(SqlInsert insert) {
        super.validateInsert(insert);
        if (!this.isCreateJob && this.isInfiniteRows(insert.getSource())) {
            throw this.newValidationError(insert, ValidatorResource.RESOURCE.mustUseCreateJob());
        }
    }

    @Override
    protected SqlSelect createSourceSelectForUpdate(SqlUpdate update) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        Table table = this.extractTable((SqlIdentifier)update.getTargetTable());
        if (table != null) {
            if (table instanceof ViewTable) {
                throw QueryException.error((String)"DML operations not supported for views");
            }
            Object connector = SqlConnectorUtil.getJetSqlConnector(table);
            if (connector.getPrimaryKey(table).isEmpty()) {
                throw QueryException.error((String)("Cannot UPDATE " + update.getTargetTable() + ": it doesn't have a primary key"));
            }
            table.getFields().forEach(field -> selectList.add(new SqlIdentifier(field.getName(), SqlParserPos.ZERO)));
        }
        int ordinal = 0;
        for (SqlNode exp : update.getSourceExpressionList()) {
            String alias = SqlUtil.deriveAliasFromOrdinal(ordinal);
            selectList.add(SqlValidatorUtil.addAlias(exp, alias));
            ++ordinal;
        }
        SqlNode sourceTable = update.getTargetTable();
        if (update.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, update.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, update.getCondition(), null, null, null, null, null, null, null);
    }

    @Override
    public void validateUpdate(final SqlUpdate update) {
        super.validateUpdate(update);
        SqlNodeList selectList = update.getSourceSelect().getSelectList();
        SqlNodeList sourceExpressionList = update.getSourceExpressionList();
        for (int i = 0; i < sourceExpressionList.size(); ++i) {
            update.getSourceExpressionList().set(i, selectList.get(selectList.size() - sourceExpressionList.size() + i));
        }
        update.getSourceSelect().getSelectList().accept(new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlCall call) {
                if (call.getKind() == SqlKind.SELECT) {
                    throw HazelcastSqlValidator.this.newValidationError(update, ValidatorResource.RESOURCE.updateFromSelectNotSupported());
                }
                return call.getOperator().acceptCall(this, call);
            }
        });
    }

    @Override
    protected SqlSelect createSourceSelectForDelete(SqlDelete delete) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        Table table = this.extractTable((SqlIdentifier)delete.getTargetTable());
        if (table != null) {
            if (table instanceof ViewTable) {
                throw QueryException.error((String)"DML operations not supported for views");
            }
            Object connector = SqlConnectorUtil.getJetSqlConnector(table);
            connector.getPrimaryKey(table).forEach(name -> selectList.add(new SqlIdentifier((String)name, SqlParserPos.ZERO)));
            if (selectList.size() == 0) {
                throw QueryException.error((String)("Cannot DELETE from " + delete.getTargetTable() + ": it doesn't have a primary key"));
            }
        }
        SqlNode sourceTable = delete.getTargetTable();
        if (delete.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, delete.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, delete.getCondition(), null, null, null, null, null, null, null);
    }

    private Table extractTable(SqlIdentifier identifier) {
        SqlValidatorTable validatorTable = this.getCatalogReader().getTable(identifier.names);
        return validatorTable == null ? null : (Table)validatorTable.unwrap(HazelcastTable.class).getTarget();
    }

    private boolean isInfiniteRows(SqlNode node) {
        this.isInfiniteRows |= this.containsStreamingSource(node);
        return this.isInfiniteRows;
    }

    public boolean containsStreamingSource(SqlNode node) {
        class FindStreamingTablesVisitor
        extends SqlBasicVisitor<Void> {
            boolean found;

            FindStreamingTablesVisitor() {
            }

            @Override
            public Void visit(SqlIdentifier id) {
                SqlValidatorTable table = HazelcastSqlValidator.this.getCatalogReader().getTable(id.names);
                if (table != null) {
                    HazelcastTable hazelcastTable = table.unwrap(HazelcastTable.class);
                    if (hazelcastTable.getTarget() instanceof ViewTable) {
                        this.found = ((ViewTable)((Object)hazelcastTable.getTarget())).isStream();
                        return null;
                    }
                    Object connector = SqlConnectorUtil.getJetSqlConnector(hazelcastTable.getTarget());
                    if (connector.isStream()) {
                        this.found = true;
                        return null;
                    }
                }
                return (Void)super.visit(id);
            }

            @Override
            public Void visit(SqlCall call) {
                SqlOperator operator = call.getOperator();
                if (operator instanceof HazelcastTableSourceFunction && ((HazelcastTableSourceFunction)operator).isStream()) {
                    this.found = true;
                    return null;
                }
                return (Void)super.visit(call);
            }
        }
        FindStreamingTablesVisitor visitor = new FindStreamingTablesVisitor();
        node.accept(visitor);
        return visitor.found;
    }

    @Override
    public RelDataType deriveTypeImpl(SqlValidatorScope scope, SqlNode operand) {
        RelDataType literalType;
        if (operand.getKind() == SqlKind.LITERAL && (literalType = LiteralUtils.literalType(operand, (HazelcastTypeFactory)this.typeFactory)) != null) {
            return literalType;
        }
        return super.deriveTypeImpl(scope, operand);
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
        if (literal instanceof SqlIntervalLiteral) {
            super.validateLiteral(literal);
        }
    }

    @Override
    public void validateDynamicParam(SqlDynamicParam dynamicParam) {
        this.parameterPositionMap.put(dynamicParam.getIndex(), dynamicParam.getParserPosition());
    }

    @Override
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        this.deriveType(scope, call);
        super.validateCall(call, scope);
    }

    @Override
    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlNode rewritten = super.performUnconditionalRewrites(node, underFrom);
        if (rewritten != null && rewritten.isA(SqlKind.TOP_LEVEL)) {
            rewritten.accept(this.rewriteVisitor);
        }
        return rewritten;
    }

    @Override
    public HazelcastTypeCoercion getTypeCoercion() {
        return (HazelcastTypeCoercion)super.getTypeCoercion();
    }

    public void setParameterConverter(int ordinal, ParameterConverter parameterConverter) {
        this.parameterConverterMap.put(ordinal, parameterConverter);
    }

    public Object getArgumentAt(int index) {
        ParameterConverter parameterConverter = this.parameterConverterMap.get(index);
        Object argument = this.arguments.get(index);
        return parameterConverter.convert(argument);
    }

    public ParameterConverter[] getParameterConverters(SqlNode node) {
        RelDataType rowType = this.getParameterRowType(node);
        ParameterConverter[] res = new ParameterConverter[rowType.getFieldCount()];
        for (int i = 0; i < res.length; ++i) {
            ParameterConverter converter = this.parameterConverterMap.get(i);
            if (converter == null) {
                QueryDataType targetType = HazelcastTypeUtils.toHazelcastType(rowType.getFieldList().get(i).getType());
                converter = AbstractParameterConverter.from(targetType, i, this.parameterPositionMap.get(i));
            }
            res[i] = converter;
        }
        return res;
    }

    private boolean isHiddenColumn(SqlNode node, SelectScope scope) {
        if (!(node instanceof SqlIdentifier)) {
            return false;
        }
        SqlIdentifier identifier = (SqlIdentifier)node;
        String fieldName = this.extractFieldName(identifier, scope);
        if (fieldName == null) {
            return false;
        }
        SqlValidatorTable table = scope.fullyQualify((SqlIdentifier)identifier).namespace.getTable();
        if (table == null) {
            return false;
        }
        HazelcastTable unwrappedTable = table.unwrap(HazelcastTable.class);
        if (unwrappedTable == null) {
            return false;
        }
        return unwrappedTable.isHidden(fieldName);
    }

    private String extractFieldName(SqlIdentifier identifier, SelectScope scope) {
        SqlCall call = this.makeNullaryCall(identifier);
        if (call != null) {
            return null;
        }
        SqlQualified qualified = scope.fullyQualify(identifier);
        ImmutableList<String> names = qualified.identifier.names;
        if (names.size() < 2) {
            return null;
        }
        return Util.last(names);
    }

    public boolean isInfiniteRows() {
        return this.isInfiniteRows;
    }

    @Override
    public CalciteContextException newValidationError(SqlNode node, Resources.ExInst<SqlValidatorException> e) {
        assert (node != null);
        CalciteContextException exception = SqlUtil.newContextException(node.getParserPosition(), e);
        if (OBJECT_NOT_FOUND.equals(ResourceUtil.key(e)) || OBJECT_NOT_FOUND_WITHIN.equals(ResourceUtil.key(e))) {
            Object[] arguments = ResourceUtil.args(e);
            String identifier = arguments != null && arguments.length > 0 ? String.valueOf(arguments[0]) : null;
            Mapping mapping = identifier != null ? this.iMapResolver.resolve(identifier) : null;
            String sql = mapping != null ? SqlCreateMapping.unparse(mapping) : null;
            String message = sql != null ? ValidatorResource.imapNotMapped(e.str(), identifier, sql) : e.str();
            throw QueryException.error((int)1010, (String)message, (Throwable)exception, (String)sql);
        }
        return exception;
    }
}

