/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.param;

import com.hazelcast.jet.sql.impl.validate.param.JsonParameterConverter;
import com.hazelcast.jet.sql.impl.validate.param.NoOpParameterConverter;
import com.hazelcast.jet.sql.impl.validate.param.NumericPrecedenceParameterConverter;
import com.hazelcast.jet.sql.impl.validate.param.StrictParameterConverter;
import com.hazelcast.jet.sql.impl.validate.param.TemporalPrecedenceParameterConverter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;

public abstract class AbstractParameterConverter
implements ParameterConverter {
    protected final int ordinal;
    protected final SqlParserPos parserPos;
    protected final QueryDataType targetType;

    protected AbstractParameterConverter(int ordinal, SqlParserPos parserPos, QueryDataType targetType) {
        this.ordinal = ordinal;
        this.parserPos = parserPos;
        this.targetType = targetType;
    }

    public QueryDataType getTargetType() {
        return this.targetType;
    }

    public final Object convert(Object value) {
        if (value == null) {
            return null;
        }
        Converter valueConverter = Converters.getConverter(value.getClass());
        if (!this.isValid(value, valueConverter)) {
            String error = String.format("Parameter at position %d must be of %s type, but %s was found (consider adding an explicit CAST)", this.ordinal, this.targetType.getTypeFamily().getPublicType(), valueConverter.getTypeFamily().getPublicType());
            throw QueryException.error((int)2000, (String)this.withContext(error));
        }
        try {
            return this.targetType.getConverter().convertToSelf(valueConverter, value);
        }
        catch (Exception e) {
            String error = String.format("Failed to convert parameter at position %d from %s to %s: %s", this.ordinal, valueConverter.getTypeFamily().getPublicType(), this.targetType.getConverter().getTypeFamily().getPublicType(), e.getMessage());
            throw QueryException.error((int)2000, (String)this.withContext(error), (Throwable)e);
        }
    }

    protected abstract boolean isValid(Object var1, Converter var2);

    private String withContext(String message) {
        int line = this.parserPos.getLineNum();
        int col = this.parserPos.getColumnNum();
        int endLine = this.parserPos.getEndLineNum();
        int endCol = this.parserPos.getEndColumnNum();
        String context = line == endLine && col == endCol ? String.format("At line %d, column %d", line, col) : String.format("From line %d, column %d to line %d, column %d", line, col, endLine, endCol);
        return context + ": " + message;
    }

    public static ParameterConverter from(QueryDataType targetType, int index, SqlParserPos parserPosition) {
        QueryDataTypeFamily targetTypeFamily = targetType.getTypeFamily();
        if (targetTypeFamily.isNumeric()) {
            return new NumericPrecedenceParameterConverter(index, parserPosition, targetType);
        }
        if (targetTypeFamily.isTemporal()) {
            return new TemporalPrecedenceParameterConverter(index, parserPosition, targetType);
        }
        if (targetTypeFamily.isObject()) {
            return NoOpParameterConverter.INSTANCE;
        }
        if (targetTypeFamily == QueryDataTypeFamily.JSON) {
            return new JsonParameterConverter(index, parserPosition, targetType);
        }
        return new StrictParameterConverter(index, parserPosition, targetType);
    }
}

