/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableLimit;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableMergeUnion;
import com.hazelcast.org.apache.calcite.adapter.enumerable.ImmutableEnumerableMergeUnionRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.core.Union;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalSort;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalUnion;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import java.util.ArrayList;
import org.immutables.value.Value;

@Value.Enclosing
public class EnumerableMergeUnionRule
extends RelRule<Config> {
    public EnumerableMergeUnionRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        RelCollation collation = sort.getCollation();
        if (collation == null || collation.getFieldCollations().isEmpty()) {
            return false;
        }
        Union union = (Union)call.rel(1);
        return union.getInputs().size() >= 2;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        RelCollation collation = sort.getCollation();
        Union union = (Union)call.rel(1);
        int unionInputsSize = union.getInputs().size();
        RexNode inputFetch = null;
        if (sort.fetch != null) {
            if (sort.offset == null) {
                inputFetch = sort.fetch;
            } else if (sort.fetch instanceof RexLiteral && sort.offset instanceof RexLiteral) {
                inputFetch = call.builder().literal(RexLiteral.intValue(sort.fetch) + RexLiteral.intValue(sort.offset));
            }
        }
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(unionInputsSize);
        for (RelNode input : union.getInputs()) {
            Sort newInput = sort.copy(sort.getTraitSet(), input, collation, null, inputFetch);
            inputs.add(EnumerableMergeUnionRule.convert((RelNode)newInput, newInput.getTraitSet().replace(EnumerableConvention.INSTANCE)));
        }
        AbstractRelNode result = EnumerableMergeUnion.create(sort.getCollation(), inputs, union.all);
        if (sort.offset != null || sort.fetch != null) {
            result = EnumerableLimit.create(result, sort.offset, sort.fetch);
        }
        call.transformTo(result);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT_CONFIG = ImmutableEnumerableMergeUnionRule.Config.of().withDescription("EnumerableMergeUnionRule").withOperandSupplier(b0 -> b0.operand(LogicalSort.class).oneInput(b1 -> b1.operand(LogicalUnion.class).anyInputs()));

        @Override
        default public EnumerableMergeUnionRule toRule() {
            return new EnumerableMergeUnionRule(this);
        }
    }
}

