/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.org.apache.calcite.interpreter.Row;
import com.hazelcast.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.org.apache.calcite.linq4j.Queryable;
import com.hazelcast.org.apache.calcite.linq4j.function.Function1;
import com.hazelcast.org.apache.calcite.linq4j.tree.Blocks;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.MethodCallExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Primitive;
import com.hazelcast.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.org.apache.calcite.plan.DeriveMode;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.schema.FilterableTable;
import com.hazelcast.org.apache.calcite.schema.ProjectableFilterableTable;
import com.hazelcast.org.apache.calcite.schema.QueryableTable;
import com.hazelcast.org.apache.calcite.schema.ScannableTable;
import com.hazelcast.org.apache.calcite.schema.StreamableTable;
import com.hazelcast.org.apache.calcite.schema.Table;
import com.hazelcast.org.apache.calcite.schema.TransientTable;
import com.hazelcast.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EnumerableTableScan
extends TableScan
implements EnumerableRel {
    private final Class elementType;

    public EnumerableTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Class elementType) {
        super(cluster, traitSet, ImmutableList.of(), table);
        assert (this.getConvention() instanceof EnumerableConvention);
        this.elementType = elementType;
        assert (EnumerableTableScan.canHandle(table)) : "EnumerableTableScan can't implement " + table + ", see EnumerableTableScan#canHandle";
    }

    @Override
    public @Nullable RelNode passThrough(RelTraitSet required) {
        return null;
    }

    @Override
    public DeriveMode getDeriveMode() {
        return DeriveMode.PROHIBITED;
    }

    public static EnumerableTableScan create(RelOptCluster cluster, RelOptTable relOptTable) {
        Table table = relOptTable.unwrap(Table.class);
        Class elementType = EnumerableTableScan.deduceElementType(table);
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> {
            if (table != null) {
                return table.getStatistic().getCollations();
            }
            return ImmutableList.of();
        });
        return new EnumerableTableScan(cluster, traitSet, relOptTable, elementType);
    }

    @Deprecated
    public static boolean canHandle(Table table) {
        if (table instanceof TransientTable) {
            return false;
        }
        return table instanceof QueryableTable || table instanceof FilterableTable || table instanceof ProjectableFilterableTable || table instanceof ScannableTable;
    }

    public static boolean canHandle(RelOptTable relOptTable) {
        Table table = relOptTable.unwrap(Table.class);
        if (table != null && !EnumerableTableScan.canHandle(table)) {
            return false;
        }
        boolean supportArray = CalciteSystemProperty.ENUMERABLE_ENABLE_TABLESCAN_ARRAY.value();
        boolean supportMap = CalciteSystemProperty.ENUMERABLE_ENABLE_TABLESCAN_MAP.value();
        boolean supportMultiset = CalciteSystemProperty.ENUMERABLE_ENABLE_TABLESCAN_MULTISET.value();
        if (supportArray && supportMap && supportMultiset) {
            return true;
        }
        for (RelDataTypeField field : relOptTable.getRowType().getFieldList()) {
            boolean unsupportedType = false;
            switch (field.getType().getSqlTypeName()) {
                case ARRAY: {
                    unsupportedType = supportArray;
                    break;
                }
                case MAP: {
                    unsupportedType = supportMap;
                    break;
                }
                case MULTISET: {
                    unsupportedType = supportMultiset;
                    break;
                }
            }
            if (!unsupportedType) continue;
            return false;
        }
        return true;
    }

    public static Class deduceElementType(@Nullable Table table) {
        if (table instanceof QueryableTable) {
            QueryableTable queryableTable = (QueryableTable)table;
            Type type = queryableTable.getElementType();
            if (type instanceof Class) {
                return (Class)type;
            }
            return Object[].class;
        }
        if (table instanceof ScannableTable || table instanceof FilterableTable || table instanceof ProjectableFilterableTable || table instanceof StreamableTable) {
            return Object[].class;
        }
        return Object.class;
    }

    public static JavaRowFormat deduceFormat(RelOptTable table) {
        Class elementType = EnumerableTableScan.deduceElementType(table.unwrapOrThrow(Table.class));
        return elementType == Object[].class ? JavaRowFormat.ARRAY : JavaRowFormat.CUSTOM;
    }

    private Expression getExpression(PhysType physType) {
        Expression expression = this.table.getExpression(Queryable.class);
        if (expression == null) {
            throw new IllegalStateException("Unable to implement " + RelOptUtil.toString(this, SqlExplainLevel.ALL_ATTRIBUTES) + ": " + this.table + ".getExpression(Queryable.class) returned null");
        }
        Expression expression2 = EnumerableTableScan.toEnumerable(expression);
        assert (Types.isAssignableFrom(Enumerable.class, expression2.getType()));
        return this.toRows(physType, expression2);
    }

    private static Expression toEnumerable(Expression expression) {
        Type type = expression.getType();
        if (Types.isArray(type)) {
            if (Objects.requireNonNull(Types.toClass(type).getComponentType()).isPrimitive()) {
                expression = Expressions.call(BuiltInMethod.AS_LIST.method, expression);
            }
            return Expressions.call(BuiltInMethod.AS_ENUMERABLE.method, expression);
        }
        if (Types.isAssignableFrom(Iterable.class, type) && !Types.isAssignableFrom(Enumerable.class, type)) {
            return Expressions.call(BuiltInMethod.AS_ENUMERABLE2.method, expression);
        }
        if (Types.isAssignableFrom(Queryable.class, type)) {
            return Expressions.call(expression, BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, new Expression[0]);
        }
        return expression;
    }

    private Expression toRows(PhysType physType, Expression expression) {
        if (physType.getFormat() == JavaRowFormat.SCALAR && Object[].class.isAssignableFrom(this.elementType) && this.getRowType().getFieldCount() == 1 && (this.table.unwrap(ScannableTable.class) != null || this.table.unwrap(FilterableTable.class) != null || this.table.unwrap(ProjectableFilterableTable.class) != null)) {
            return Expressions.call(BuiltInMethod.SLICE0.method, expression);
        }
        JavaRowFormat oldFormat = this.format();
        if (physType.getFormat() == oldFormat && !EnumerableTableScan.hasCollectionField(this.getRowType())) {
            return expression;
        }
        ParameterExpression row_ = Expressions.parameter(this.elementType, "row");
        int fieldCount = this.table.getRowType().getFieldCount();
        ArrayList<Expression> expressionList = new ArrayList<Expression>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            expressionList.add(this.fieldExpression(row_, i, physType, oldFormat));
        }
        return Expressions.call(expression, BuiltInMethod.SELECT.method, Expressions.lambda(Function1.class, physType.record(expressionList), row_));
    }

    private Expression fieldExpression(ParameterExpression row_, int i, PhysType physType, JavaRowFormat format) {
        Expression e = format.field(row_, i, null, physType.getJavaFieldType(i));
        RelDataType relFieldType = physType.getRowType().getFieldList().get(i).getType();
        switch (relFieldType.getSqlTypeName()) {
            case ARRAY: 
            case MULTISET: {
                RelDataType fieldType = Objects.requireNonNull(relFieldType.getComponentType(), () -> "relFieldType.getComponentType() for " + relFieldType);
                if (fieldType.isStruct()) {
                    JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
                    PhysType elementPhysType = PhysTypeImpl.of(typeFactory, fieldType, JavaRowFormat.CUSTOM);
                    MethodCallExpression e2 = Expressions.call(BuiltInMethod.AS_ENUMERABLE2.method, e);
                    Expression e3 = elementPhysType.convertTo((Expression)e2, JavaRowFormat.LIST);
                    return Expressions.call(e3, BuiltInMethod.ENUMERABLE_TO_LIST.method, new Expression[0]);
                }
                return e;
            }
        }
        return e;
    }

    private JavaRowFormat format() {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldCount == 0) {
            return JavaRowFormat.LIST;
        }
        if (Object[].class.isAssignableFrom(this.elementType)) {
            return fieldCount == 1 ? JavaRowFormat.SCALAR : JavaRowFormat.ARRAY;
        }
        if (Row.class.isAssignableFrom(this.elementType)) {
            return JavaRowFormat.ROW;
        }
        if (fieldCount == 1 && (Object.class == this.elementType || Primitive.is(this.elementType) || Number.class.isAssignableFrom(this.elementType) || String.class == this.elementType)) {
            return JavaRowFormat.SCALAR;
        }
        return JavaRowFormat.CUSTOM;
    }

    private static boolean hasCollectionField(RelDataType rowType) {
        for (RelDataTypeField field : rowType.getFieldList()) {
            switch (field.getType().getSqlTypeName()) {
                case ARRAY: 
                case MULTISET: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableTableScan(this.getCluster(), traitSet, this.table, this.elementType);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), this.format());
        Expression expression = this.getExpression(physType);
        return implementor.result(physType, Blocks.toBlock(expression));
    }
}

