/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.linq4j.tree;

import com.hazelcast.org.apache.calcite.linq4j.tree.Blocks;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.Node;
import com.hazelcast.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.org.apache.calcite.linq4j.tree.Statement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public class ConditionalStatement
extends Statement {
    public final List<Node> expressionList;

    public ConditionalStatement(List<Node> expressionList) {
        super(ExpressionType.Conditional, Void.TYPE);
        assert (expressionList != null) : "expressionList should not be null";
        this.expressionList = expressionList;
    }

    @Override
    public Statement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        List<Node> list = Expressions.acceptNodes(this.expressionList, shuttle);
        return shuttle.visit(this, list);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        for (int i = 0; i < this.expressionList.size() - 1; i += 2) {
            if (i > 0) {
                writer.backUp();
                writer.append(" else ");
            }
            writer.append("if (").append(this.expressionList.get(i)).append(") ").append(Blocks.toBlock(this.expressionList.get(i + 1)));
        }
        if (this.expressionList.size() % 2 == 1) {
            writer.backUp();
            writer.append(" else ").append(Blocks.toBlock(ConditionalStatement.last(this.expressionList)));
        }
    }

    private static <E> E last(List<E> collection) {
        return collection.get(collection.size() - 1);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionalStatement that = (ConditionalStatement)o;
        return this.expressionList.equals(that.expressionList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.expressionList});
    }
}

