/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.linq4j.tree;

import com.hazelcast.org.apache.calcite.linq4j.tree.BlockStatement;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.org.apache.calcite.linq4j.tree.MemberDeclaration;
import com.hazelcast.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;

public class ConstructorDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final Type resultType;
    public final List<ParameterExpression> parameters;
    public final BlockStatement body;
    private int hash;

    public ConstructorDeclaration(int modifier, Type declaredAgainst, List<ParameterExpression> parameters, BlockStatement body) {
        assert (parameters != null) : "parameters should not be null";
        assert (body != null) : "body should not be null";
        assert (declaredAgainst != null) : "declaredAgainst should not be null";
        this.modifier = modifier;
        this.resultType = declaredAgainst;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    public MemberDeclaration accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        BlockStatement body = this.body.accept(shuttle);
        return shuttle.visit(this, body);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.resultType).list("(", ", ", ")", () -> this.parameters.stream().map(parameter -> {
            String modifiers1 = Modifier.toString(parameter.modifier);
            return modifiers1 + (modifiers1.isEmpty() ? "" : " ") + Types.className(parameter.getType()) + " " + parameter.name;
        }).iterator()).append(' ').append(this.body);
        writer.newlineAndIndent();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorDeclaration that = (ConstructorDeclaration)o;
        if (this.modifier != that.modifier) {
            return false;
        }
        if (!this.body.equals(that.body)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.resultType.equals(that.resultType);
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(this.modifier, this.resultType, this.parameters, this.body);
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

