/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.linq4j.tree;

import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;

public class NewArrayExpression
extends Expression {
    public final int dimension;
    public final @Nullable Expression bound;
    public final @Nullable List<Expression> expressions;
    private int hash;

    public NewArrayExpression(Type type, int dimension, @Nullable Expression bound, @Nullable List<Expression> expressions) {
        super(ExpressionType.NewArrayInit, Types.arrayType(type, dimension));
        this.dimension = dimension;
        this.bound = bound;
        this.expressions = expressions;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        List<Expression> expressions = this.expressions == null ? null : Expressions.acceptExpressions(this.expressions, shuttle);
        Expression bound = this.bound == null ? null : this.bound.accept(shuttle);
        return shuttle.visit(this, this.dimension, bound, expressions);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append("new ").append(Types.getComponentTypeN(this.type));
        for (int i = 0; i < this.dimension; ++i) {
            if (i == 0 && this.bound != null) {
                writer.append('[').append(this.bound).append(']');
                continue;
            }
            writer.append("[]");
        }
        if (this.expressions != null) {
            writer.list(" {\n", ",\n", "}", this.expressions);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NewArrayExpression that = (NewArrayExpression)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        if (this.bound != null ? !this.bound.equals(that.bound) : that.bound != null) {
            return false;
        }
        return !(this.expressions != null ? !this.expressions.equals(that.expressions) : that.expressions != null);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, this.type, this.dimension, this.bound, this.expressions});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

