/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperandChildPolicy;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.ImmutableBeans;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public abstract class RelRule<C extends Config>
extends RelOptRule {
    public final C config;

    protected RelRule(C config) {
        super(OperandBuilderImpl.operand(config.operandSupplier()), config.relBuilderFactory(), config.description());
        this.config = config;
    }

    public static interface MatchHandler<R extends RelOptRule>
    extends BiConsumer<R, RelOptRuleCall> {
    }

    private static enum DoneImpl implements Done
    {
        INSTANCE;

    }

    private static class OperandDetailBuilderImpl<R extends RelNode>
    implements OperandDetailBuilder<R> {
        private final OperandBuilderImpl parent;
        private final Class<R> relClass;
        final OperandBuilderImpl inputBuilder = new OperandBuilderImpl();
        private @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable RelTrait trait;
        private Predicate<? super R> predicate = r -> true;

        OperandDetailBuilderImpl(OperandBuilderImpl parent, Class<R> relClass) {
            this.parent = Objects.requireNonNull(parent, "parent");
            this.relClass = Objects.requireNonNull(relClass, "relClass");
        }

        @Override
        public OperandDetailBuilderImpl<R> trait(RelTrait trait) {
            this.trait = Objects.requireNonNull(trait, "trait");
            return this;
        }

        @Override
        public OperandDetailBuilderImpl<R> predicate(Predicate<? super R> predicate) {
            this.predicate = predicate;
            return this;
        }

        Done done(RelOptRuleOperandChildPolicy childPolicy) {
            this.parent.operands.add(new RelOptRuleOperand(this.relClass, this.trait, this.predicate, childPolicy, ImmutableList.copyOf(this.inputBuilder.operands)));
            return DoneImpl.INSTANCE;
        }

        @Override
        public Done convert(RelTrait in) {
            this.parent.operands.add(new RelOptRule.ConverterRelOptRuleOperand(this.relClass, in, this.predicate));
            return DoneImpl.INSTANCE;
        }

        @Override
        public Done noInputs() {
            return this.done(RelOptRuleOperandChildPolicy.LEAF);
        }

        @Override
        public Done anyInputs() {
            return this.done(RelOptRuleOperandChildPolicy.ANY);
        }

        @Override
        public Done oneInput(OperandTransform transform) {
            Done done = (Done)transform.apply(this.inputBuilder);
            Objects.requireNonNull(done, "done");
            return this.done(RelOptRuleOperandChildPolicy.SOME);
        }

        @Override
        public Done inputs(OperandTransform ... transforms) {
            for (OperandTransform transform : transforms) {
                Done done = (Done)transform.apply(this.inputBuilder);
                Objects.requireNonNull(done, "done");
            }
            return this.done(RelOptRuleOperandChildPolicy.SOME);
        }

        @Override
        public Done unorderedInputs(OperandTransform ... transforms) {
            for (OperandTransform transform : transforms) {
                Done done = (Done)transform.apply(this.inputBuilder);
                Objects.requireNonNull(done, "done");
            }
            return this.done(RelOptRuleOperandChildPolicy.UNORDERED);
        }
    }

    private static class OperandBuilderImpl
    implements OperandBuilder {
        final List<RelOptRuleOperand> operands = new ArrayList<RelOptRuleOperand>();

        private OperandBuilderImpl() {
        }

        static RelOptRuleOperand operand(OperandTransform transform) {
            OperandBuilderImpl b = new OperandBuilderImpl();
            Done done = (Done)transform.apply(b);
            Objects.requireNonNull(done, "done");
            if (b.operands.size() != 1) {
                throw new IllegalArgumentException("operand supplier must call one of the following methods: operand or exactly");
            }
            return b.operands.get(0);
        }

        @Override
        public <R extends RelNode> OperandDetailBuilder<R> operand(Class<R> relClass) {
            return new OperandDetailBuilderImpl<R>(this, relClass);
        }

        @Override
        public Done exactly(RelOptRuleOperand operand) {
            this.operands.add(operand);
            return DoneImpl.INSTANCE;
        }
    }

    public static interface OperandDetailBuilder<R extends RelNode> {
        public OperandDetailBuilder<R> trait(RelTrait var1);

        public OperandDetailBuilder<R> predicate(Predicate<? super R> var1);

        public Done oneInput(OperandTransform var1);

        public Done inputs(OperandTransform ... var1);

        public Done unorderedInputs(OperandTransform ... var1);

        public Done anyInputs();

        public Done noInputs();

        public Done convert(RelTrait var1);
    }

    public static interface Done {
    }

    public static interface OperandBuilder {
        public <R extends RelNode> OperandDetailBuilder<R> operand(Class<R> var1);

        public Done exactly(RelOptRuleOperand var1);
    }

    @FunctionalInterface
    public static interface OperandTransform
    extends Function<OperandBuilder, Done> {
    }

    public static interface Config {
        @Deprecated
        public static final Config EMPTY = ImmutableBeans.create(Config.class).withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withOperandSupplier(b -> {
            throw new IllegalArgumentException("Rules must have at least one operand. Call Config.withOperandSupplier to specify them.");
        });

        public RelOptRule toRule();

        default public <T> T as(Class<T> class_) {
            if (Proxy.isProxyClass(this.getClass())) {
                return ImmutableBeans.copy(class_, this);
            }
            if (class_.isAssignableFrom(this.getClass())) {
                return class_.cast(this);
            }
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "The current config of type %s is not an instance of %s.", this.getClass(), class_));
        }

        @ImmutableBeans.Property
        @Value.Default
        default public RelBuilderFactory relBuilderFactory() {
            return RelFactories.LOGICAL_BUILDER;
        }

        public Config withRelBuilderFactory(RelBuilderFactory var1);

        @ImmutableBeans.Property
        @Nullable
        public @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description();

        public Config withDescription(@com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String var1);

        @ImmutableBeans.Property
        @Value.Default
        default public OperandTransform operandSupplier() {
            return s2 -> {
                throw new IllegalArgumentException("Rules must have at least one operand. Call Config.withOperandSupplier to specify them.");
            };
        }

        public Config withOperandSupplier(OperandTransform var1);
    }
}

