/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.core;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.runtime.FlatLists;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.org.apache.calcite.util.mapping.IntPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JoinInfo {
    public final ImmutableIntList leftKeys;
    public final ImmutableIntList rightKeys;
    public final ImmutableList<RexNode> nonEquiConditions;

    protected JoinInfo(ImmutableIntList leftKeys, ImmutableIntList rightKeys, ImmutableList<RexNode> nonEquiConditions) {
        this.leftKeys = Objects.requireNonNull(leftKeys, "leftKeys");
        this.rightKeys = Objects.requireNonNull(rightKeys, "rightKeys");
        this.nonEquiConditions = Objects.requireNonNull(nonEquiConditions, "nonEquiConditions");
        assert (leftKeys.size() == rightKeys.size());
    }

    public static JoinInfo of(RelNode left, RelNode right, RexNode condition) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        ArrayList<Boolean> filterNulls = new ArrayList<Boolean>();
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys, filterNulls, nonEquiList);
        return new JoinInfo(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys), ImmutableList.copyOf(nonEquiList));
    }

    public static JoinInfo of(ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        return new JoinInfo(leftKeys, rightKeys, ImmutableList.of());
    }

    public boolean isEqui() {
        return this.nonEquiConditions.isEmpty();
    }

    public List<IntPair> pairs() {
        return IntPair.zip(this.leftKeys, this.rightKeys);
    }

    public ImmutableBitSet leftSet() {
        return ImmutableBitSet.of(this.leftKeys);
    }

    public ImmutableBitSet rightSet() {
        return ImmutableBitSet.of(this.rightKeys);
    }

    @Deprecated
    public RexNode getRemaining(RexBuilder rexBuilder) {
        return RexUtil.composeConjunction(rexBuilder, this.nonEquiConditions);
    }

    public RexNode getEquiCondition(RelNode left, RelNode right, RexBuilder rexBuilder) {
        return RelOptUtil.createEquiJoinCondition(left, this.leftKeys, right, this.rightKeys, rexBuilder);
    }

    public List<ImmutableIntList> keys() {
        return FlatLists.of(this.leftKeys, this.rightKeys);
    }
}

