/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import com.hazelcast.org.checkerframework.checker.initialization.qual.UnderInitialization;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LoptJoinTree {
    @NotOnlyInitialized
    private final BinaryTree factorTree;
    private final RelNode joinTree;
    private final boolean removableSelfJoin;

    public LoptJoinTree(RelNode joinTree, int factorId) {
        this.joinTree = joinTree;
        this.factorTree = new Leaf(factorId, this);
        this.removableSelfJoin = false;
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree factorTree, boolean removableSelfJoin) {
        this.joinTree = joinTree;
        this.factorTree = factorTree;
        this.removableSelfJoin = removableSelfJoin;
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree leftFactorTree, BinaryTree rightFactorTree) {
        this(joinTree, leftFactorTree, rightFactorTree, false);
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree leftFactorTree, BinaryTree rightFactorTree, boolean removableSelfJoin) {
        this.factorTree = new Node(leftFactorTree, rightFactorTree, this);
        this.joinTree = joinTree;
        this.removableSelfJoin = removableSelfJoin;
    }

    public RelNode getJoinTree() {
        return this.joinTree;
    }

    public LoptJoinTree getLeft() {
        Node node = (Node)this.factorTree;
        return new LoptJoinTree(((Join)this.joinTree).getLeft(), node.getLeft(), node.getLeft().getParent().isRemovableSelfJoin());
    }

    public LoptJoinTree getRight() {
        Node node = (Node)this.factorTree;
        return new LoptJoinTree(((Join)this.joinTree).getRight(), node.getRight(), node.getRight().getParent().isRemovableSelfJoin());
    }

    public BinaryTree getFactorTree() {
        return this.factorTree;
    }

    public List<Integer> getTreeOrder() {
        ArrayList<Integer> treeOrder = new ArrayList<Integer>();
        this.getTreeOrder(treeOrder);
        return treeOrder;
    }

    public void getTreeOrder(List<Integer> treeOrder) {
        this.factorTree.getTreeOrder(treeOrder);
    }

    public boolean isRemovableSelfJoin() {
        return this.removableSelfJoin;
    }

    protected static class Node
    extends BinaryTree {
        private final BinaryTree left;
        private final BinaryTree right;

        public Node(BinaryTree left, BinaryTree right, @UnderInitialization LoptJoinTree parent) {
            super(parent);
            this.left = Objects.requireNonNull(left, "left");
            this.right = Objects.requireNonNull(right, "right");
        }

        public BinaryTree getLeft() {
            return this.left;
        }

        public BinaryTree getRight() {
            return this.right;
        }

        @Override
        public void getTreeOrder(List<Integer> treeOrder) {
            this.left.getTreeOrder(treeOrder);
            this.right.getTreeOrder(treeOrder);
        }
    }

    protected static class Leaf
    extends BinaryTree {
        private final int id;

        public Leaf(int rootId, @UnderInitialization LoptJoinTree parent) {
            super(parent);
            this.id = rootId;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public void getTreeOrder(List<Integer> treeOrder) {
            treeOrder.add(this.id);
        }
    }

    protected static abstract class BinaryTree {
        @NotOnlyInitialized
        private final LoptJoinTree parent;

        protected BinaryTree(@UnderInitialization LoptJoinTree parent) {
            this.parent = parent;
        }

        public LoptJoinTree getParent() {
            return this.parent;
        }

        public abstract void getTreeOrder(List<Integer> var1);
    }
}

