/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableProjectRemoveRule;
import com.hazelcast.org.apache.calcite.rel.rules.SubstitutionRule;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class ProjectRemoveRule
extends RelRule<Config>
implements SubstitutionRule {
    protected ProjectRemoveRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectRemoveRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        assert (ProjectRemoveRule.isTrivial(project));
        RelNode stripped = project.getInput();
        if (stripped instanceof Project) {
            Project childProject = (Project)stripped;
            stripped = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), project.getRowType());
        }
        stripped = ProjectRemoveRule.convert(stripped, project.getConvention());
        call.transformTo(stripped);
    }

    public static RelNode strip(Project project) {
        return ProjectRemoveRule.isTrivial(project) ? project.getInput() : project;
    }

    public static boolean isTrivial(Project project) {
        return RexUtil.isIdentity(project.getProjects(), project.getInput().getRowType());
    }

    @Override
    public boolean autoPruneOld() {
        return true;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableProjectRemoveRule.Config.of().withOperandSupplier(b -> b.operand(Project.class).predicate(ProjectRemoveRule::isTrivial).anyInputs());

        @Override
        default public ProjectRemoveRule toRule() {
            return new ProjectRemoveRule(this);
        }
    }
}

