/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.sql.SqlAsOperator;
import com.hazelcast.org.apache.calcite.sql.SqlBasicCall;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public class SqlSnapshot
extends SqlCall {
    private static final int OPERAND_TABLE_REF = 0;
    private static final int OPERAND_PERIOD = 1;
    private SqlNode tableRef;
    private SqlNode period;

    public SqlSnapshot(SqlParserPos pos, SqlNode tableRef, SqlNode period) {
        super(pos);
        this.tableRef = Objects.requireNonNull(tableRef, "tableRef");
        this.period = Objects.requireNonNull(period, "period");
    }

    @Override
    public SqlOperator getOperator() {
        return SqlSnapshotOperator.INSTANCE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableRef, this.period);
    }

    public SqlNode getTableRef() {
        return this.tableRef;
    }

    public SqlNode getPeriod() {
        return this.period;
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.tableRef = Objects.requireNonNull(operand, "operand");
                break;
            }
            case 1: {
                this.period = Objects.requireNonNull(operand, "operand");
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.getOperator().unparse(writer, this, 0, 0);
    }

    public static class SqlSnapshotOperator
    extends SqlOperator {
        public static final SqlSnapshotOperator INSTANCE = new SqlSnapshotOperator();

        private SqlSnapshotOperator() {
            super("SNAPSHOT", SqlKind.SNAPSHOT, 2, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            assert (operands.length == 2);
            return new SqlSnapshot(pos, operands[0], operands[1]);
        }

        @Override
        public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
            if (onlyExpressions) {
                List<SqlNode> operands = call.getOperandList();
                for (int i = 1; i < operands.size(); ++i) {
                    argHandler.visitChild(visitor, call, i, operands.get(i));
                }
            } else {
                super.acceptCall(visitor, call, false, argHandler);
            }
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlSnapshot snapshot = (SqlSnapshot)call;
            SqlNode tableRef = snapshot.tableRef;
            if (tableRef instanceof SqlBasicCall && ((SqlBasicCall)tableRef).getOperator() instanceof SqlAsOperator) {
                SqlBasicCall basicCall = (SqlBasicCall)tableRef;
                ((SqlNode)basicCall.operand(0)).unparse(writer, 0, 0);
                writer.setNeedWhitespace(true);
                SqlSnapshotOperator.writeForSystemTimeAsOf(writer, snapshot);
                writer.keyword("AS");
                ((SqlNode)basicCall.operand(1)).unparse(writer, 0, 0);
            } else {
                tableRef.unparse(writer, 0, 0);
                SqlSnapshotOperator.writeForSystemTimeAsOf(writer, snapshot);
            }
        }

        private static void writeForSystemTimeAsOf(SqlWriter writer, SqlSnapshot snapshot) {
            writer.keyword("FOR SYSTEM_TIME AS OF");
            snapshot.period.unparse(writer, 0, 0);
        }
    }
}

