/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.ddl;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class SqlCheckConstraint
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CHECK", SqlKind.CHECK);
    private final @Nullable SqlIdentifier name;
    private final SqlNode expression;

    SqlCheckConstraint(SqlParserPos pos, @Nullable SqlIdentifier name, SqlNode expression) {
        super(pos);
        this.name = name;
        this.expression = expression;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.expression);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.name != null) {
            writer.keyword("CONSTRAINT");
            this.name.unparse(writer, 0, 0);
        }
        writer.keyword("CHECK");
        if (writer.isAlwaysUseParentheses()) {
            this.expression.unparse(writer, 0, 0);
        } else {
            writer.sep("(");
            this.expression.unparse(writer, 0, 0);
            writer.sep(")");
        }
    }
}

