/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.ddl;

import com.hazelcast.com.google.common.base.Preconditions;
import com.hazelcast.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SqlCreateFunction
extends SqlCreate {
    private final SqlIdentifier name;
    private final SqlNode className;
    private final SqlNodeList usingList;
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE FUNCTION", SqlKind.CREATE_FUNCTION);

    public SqlCreateFunction(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode className, SqlNodeList usingList) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
        this.className = className;
        this.usingList = Objects.requireNonNull(usingList, "usingList");
        Preconditions.checkArgument(usingList.size() % 2 == 0);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getReplace() ? "CREATE OR REPLACE" : "CREATE");
        writer.keyword("FUNCTION");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, 0, 0);
        writer.keyword("AS");
        this.className.unparse(writer, 0, 0);
        if (this.usingList.size() > 0) {
            writer.keyword("USING");
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
            for (Pair<SqlLiteral, SqlLiteral> using : this.pairs()) {
                writer.sep(",");
                ((SqlLiteral)using.left).unparse(writer, 0, 0);
                ((SqlLiteral)using.right).unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    private List<Pair<SqlLiteral, SqlLiteral>> pairs() {
        return Util.pairs(this.usingList);
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.name, this.className, this.usingList);
    }
}

