/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;

public class SqlOverlayFunction
extends SqlFunction {
    private static final SqlOperandTypeChecker OTC_CUSTOM = OperandTypes.or(OperandTypes.STRING_STRING_INTEGER, OperandTypes.STRING_STRING_INTEGER_INTEGER);

    public SqlOverlayFunction() {
        super("OVERLAY", SqlKind.OTHER_FUNCTION, ReturnTypes.DYADIC_STRING_SUM_PRECISION_NULLABLE_VARYING, null, OTC_CUSTOM, SqlFunctionCategory.STRING);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep("PLACING");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        if (4 == call.operandCount()) {
            writer.sep("FOR");
            ((SqlNode)call.operand(3)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 3: {
                return "{0}({1} PLACING {2} FROM {3})";
            }
            case 4: {
                return "{0}({1} PLACING {2} FROM {3} FOR {4})";
            }
        }
        throw new IllegalArgumentException("operandsCount shuld be 3 or 4, got " + operandsCount);
    }
}

