/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.parser;

import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.org.apache.calcite.avatica.util.Casing;
import com.hazelcast.org.apache.calcite.avatica.util.Quoting;
import com.hazelcast.org.apache.calcite.config.CharLiteralStyle;
import com.hazelcast.org.apache.calcite.config.Lex;
import com.hazelcast.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.parser.ImmutableSqlParser;
import com.hazelcast.org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParseException;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserImplFactory;
import com.hazelcast.org.apache.calcite.sql.parser.impl.SqlParserImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformanceEnum;
import com.hazelcast.org.apache.calcite.sql.validate.SqlDelegatingConformance;
import com.hazelcast.org.apache.calcite.util.SourceStringReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

@Value.Enclosing
public class SqlParser {
    public static final int DEFAULT_IDENTIFIER_MAX_LENGTH = 128;
    @Deprecated
    public static final boolean DEFAULT_ALLOW_BANG_EQUAL = SqlConformanceEnum.DEFAULT.isBangEqualAllowed();
    private final SqlAbstractParserImpl parser;

    private SqlParser(SqlAbstractParserImpl parser, Config config) {
        this.parser = parser;
        parser.setTabSize(1);
        parser.setQuotedCasing(config.quotedCasing());
        parser.setUnquotedCasing(config.unquotedCasing());
        parser.setIdentifierMaxLength(config.identifierMaxLength());
        parser.setConformance(config.conformance());
        parser.switchTo(SqlAbstractParserImpl.LexicalState.forConfig(config));
    }

    public static SqlParser create(String s2) {
        return SqlParser.create(s2, SqlParser.config());
    }

    public static SqlParser create(String sql, Config config) {
        return SqlParser.create(new SourceStringReader(sql), config);
    }

    public static SqlParser create(Reader reader, Config config) {
        SqlAbstractParserImpl parser = config.parserFactory().getParser(reader);
        return new SqlParser(parser, config);
    }

    public SqlNode parseExpression() throws SqlParseException {
        try {
            return this.parser.parseSqlExpressionEof();
        }
        catch (Throwable ex) {
            String originalSql;
            if (ex instanceof CalciteContextException && (originalSql = this.parser.getOriginalSql()) != null) {
                ((CalciteContextException)ex).setOriginalStatement(originalSql);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    private SqlParseException handleException(Throwable ex) {
        String originalSql;
        if (ex instanceof CalciteContextException && (originalSql = this.parser.getOriginalSql()) != null) {
            ((CalciteContextException)ex).setOriginalStatement(originalSql);
        }
        return this.parser.normalizeException(ex);
    }

    public SqlNode parseQuery() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtEof();
        }
        catch (Throwable ex) {
            throw this.handleException(ex);
        }
    }

    public SqlNode parseQuery(String sql) throws SqlParseException {
        this.parser.ReInit(new StringReader(sql));
        return this.parseQuery();
    }

    public SqlNode parseStmt() throws SqlParseException {
        return this.parseQuery();
    }

    public SqlNodeList parseStmtList() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtList();
        }
        catch (Throwable ex) {
            throw this.handleException(ex);
        }
    }

    public SqlAbstractParserImpl.Metadata getMetadata() {
        return this.parser.getMetadata();
    }

    public List<CalciteContextException> getWarnings() {
        return this.parser.warnings;
    }

    public static Config config() {
        return Config.DEFAULT;
    }

    @Deprecated
    public static ConfigBuilder configBuilder() {
        return new ConfigBuilder();
    }

    @Deprecated
    public static ConfigBuilder configBuilder(Config config) {
        return new ConfigBuilder().setConfig(config);
    }

    @Deprecated
    public static class ConfigBuilder {
        private Config config = Config.DEFAULT;

        private ConfigBuilder() {
        }

        public ConfigBuilder setConfig(Config config) {
            this.config = config;
            return this;
        }

        public ConfigBuilder setQuotedCasing(Casing quotedCasing) {
            return this.setConfig(this.config.withQuotedCasing(quotedCasing));
        }

        public ConfigBuilder setUnquotedCasing(Casing unquotedCasing) {
            return this.setConfig(this.config.withUnquotedCasing(unquotedCasing));
        }

        public ConfigBuilder setQuoting(Quoting quoting) {
            return this.setConfig(this.config.withQuoting(quoting));
        }

        public ConfigBuilder setCaseSensitive(boolean caseSensitive) {
            return this.setConfig(this.config.withCaseSensitive(caseSensitive));
        }

        public ConfigBuilder setIdentifierMaxLength(int identifierMaxLength) {
            return this.setConfig(this.config.withIdentifierMaxLength(identifierMaxLength));
        }

        @Deprecated
        public ConfigBuilder setAllowBangEqual(final boolean allowBangEqual) {
            if (allowBangEqual != this.config.conformance().isBangEqualAllowed()) {
                return this.setConformance(new SqlDelegatingConformance(this.config.conformance()){

                    @Override
                    public boolean isBangEqualAllowed() {
                        return allowBangEqual;
                    }
                });
            }
            return this;
        }

        public ConfigBuilder setConformance(SqlConformance conformance) {
            return this.setConfig(this.config.withConformance(conformance));
        }

        public ConfigBuilder setCharLiteralStyles(Set<CharLiteralStyle> charLiteralStyles) {
            return this.setConfig(this.config.withCharLiteralStyles(charLiteralStyles));
        }

        public ConfigBuilder setParserFactory(SqlParserImplFactory factory) {
            return this.setConfig(this.config.withParserFactory(factory));
        }

        public ConfigBuilder setLex(Lex lex) {
            return this.setConfig(this.config.withLex(lex));
        }

        public Config build() {
            return this.config;
        }
    }

    @Value.Immutable
    public static interface Config {
        public static final Config DEFAULT = ImmutableSqlParser.Config.of();

        @Value.Default
        default public int identifierMaxLength() {
            return 128;
        }

        public Config withIdentifierMaxLength(int var1);

        @Value.Default
        default public Casing quotedCasing() {
            return Casing.UNCHANGED;
        }

        public Config withQuotedCasing(Casing var1);

        @Value.Default
        default public Casing unquotedCasing() {
            return Casing.TO_UPPER;
        }

        public Config withUnquotedCasing(Casing var1);

        @Value.Default
        default public Quoting quoting() {
            return Quoting.DOUBLE_QUOTE;
        }

        public Config withQuoting(Quoting var1);

        @Value.Default
        default public boolean caseSensitive() {
            return true;
        }

        public Config withCaseSensitive(boolean var1);

        @Value.Default
        default public SqlConformance conformance() {
            return SqlConformanceEnum.DEFAULT;
        }

        public Config withConformance(SqlConformance var1);

        @Deprecated
        @Value.Default
        default public boolean allowBangEqual() {
            return DEFAULT_ALLOW_BANG_EQUAL;
        }

        @Value.Default
        default public Set<CharLiteralStyle> charLiteralStyles() {
            return ImmutableSet.of(CharLiteralStyle.STANDARD);
        }

        public Config withCharLiteralStyles(Iterable<CharLiteralStyle> var1);

        @Value.Default
        default public SqlParserImplFactory parserFactory() {
            return SqlParserImpl.FACTORY;
        }

        public Config withParserFactory(SqlParserImplFactory var1);

        default public Config withLex(Lex lex) {
            return this.withCaseSensitive(lex.caseSensitive).withUnquotedCasing(lex.unquotedCasing).withQuotedCasing(lex.quotedCasing).withQuoting(lex.quoting).withCharLiteralStyles(lex.charLiteralStyles);
        }
    }
}

