/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface SqlTypeMappingRule {
    public Map<SqlTypeName, ImmutableSet<SqlTypeName>> getTypeMapping();

    default public boolean canApplyFrom(SqlTypeName to, SqlTypeName from) {
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(from, "from");
        if (to == SqlTypeName.NULL) {
            return false;
        }
        if (from == SqlTypeName.NULL) {
            return true;
        }
        Set rule = this.getTypeMapping().get((Object)to);
        if (rule == null) {
            throw new AssertionError((Object)("No assign rules for " + (Object)((Object)to) + " defined"));
        }
        return rule.contains((Object)from);
    }
}

