/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMoniker;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonikerType;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public class SqlMonikerImpl
implements SqlMoniker {
    private final ImmutableList<String> names;
    private final SqlMonikerType type;

    public SqlMonikerImpl(List<String> names, SqlMonikerType type) {
        this.names = ImmutableList.copyOf(names);
        this.type = Objects.requireNonNull(type, "type");
    }

    public SqlMonikerImpl(String name, SqlMonikerType type) {
        this(ImmutableList.of(name), type);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SqlMonikerImpl && this.type == ((SqlMonikerImpl)obj).type && this.names.equals(((SqlMonikerImpl)obj).names);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.names});
    }

    @Override
    public SqlMonikerType getType() {
        return this.type;
    }

    @Override
    public List<String> getFullyQualifiedNames() {
        return this.names;
    }

    @Override
    public SqlIdentifier toIdentifier() {
        return new SqlIdentifier(this.names, SqlParserPos.ZERO);
    }

    public String toString() {
        return Util.sepList(this.names, ".");
    }

    @Override
    public String id() {
        return (Object)((Object)this.type) + "(" + this + ")";
    }
}

