/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.jsfr.json.resolver;

import com.hazelcast.org.jsfr.json.exception.ResolverException;
import com.hazelcast.org.jsfr.json.resolver.DocumentResolver;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;

public class PoJoResolver
implements DocumentResolver<Object, Object> {
    @Override
    public Object resolve(Object object, String field) {
        Object value;
        try {
            Field declaredField = object.getClass().getDeclaredField(field);
            declaredField.setAccessible(true);
            value = declaredField.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ResolverException("Failed to resolve field: " + field, e);
        }
        return value;
    }

    @Override
    public Object resolve(Object list, int index) {
        if (list instanceof List) {
            return ((List)list).get(index);
        }
        if (list.getClass().isArray()) {
            return Array.get(list, index);
        }
        throw new UnsupportedOperationException("Unsupported list object " + list);
    }
}

