/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

import com.hazelcast.com.esri.core.geometry.Boundary;
import com.hazelcast.com.esri.core.geometry.CrackAndCluster;
import com.hazelcast.com.esri.core.geometry.EditShape;
import com.hazelcast.com.esri.core.geometry.Envelope;
import com.hazelcast.com.esri.core.geometry.Envelope2D;
import com.hazelcast.com.esri.core.geometry.Geometry;
import com.hazelcast.com.esri.core.geometry.GeometryException;
import com.hazelcast.com.esri.core.geometry.InternalUtils;
import com.hazelcast.com.esri.core.geometry.MultiPoint;
import com.hazelcast.com.esri.core.geometry.Point;
import com.hazelcast.com.esri.core.geometry.Point2D;
import com.hazelcast.com.esri.core.geometry.Polygon;
import com.hazelcast.com.esri.core.geometry.PolygonUtils;
import com.hazelcast.com.esri.core.geometry.Polyline;
import com.hazelcast.com.esri.core.geometry.ProgressTracker;
import com.hazelcast.com.esri.core.geometry.RelationalOperations;
import com.hazelcast.com.esri.core.geometry.Segment;
import com.hazelcast.com.esri.core.geometry.Simplificator;
import com.hazelcast.com.esri.core.geometry.SpatialReference;
import com.hazelcast.com.esri.core.geometry.TopoGraph;

class RelationalOperationsMatrix {
    private TopoGraph m_topo_graph = new TopoGraph();
    private int[] m_matrix = new int[9];
    private int[] m_max_dim = new int[9];
    private boolean[] m_perform_predicates = new boolean[9];
    private String m_scl;
    private int m_predicates_half_edge = -1;
    private int m_predicates_cluster = -1;
    private int m_predicate_count = 0;
    private int m_cluster_index_a;
    private int m_cluster_index_b;
    private int m_visited_index;

    static boolean relate(Geometry geometry_a, Geometry geometry_b, SpatialReference sr, String scl, ProgressTracker progress_tracker) {
        if (scl.length() != 9) {
            throw new GeometryException("relation string length has to be 9 characters");
        }
        for (int i = 0; i < 9; ++i) {
            char c = scl.charAt(i);
            if (c == '*' || c == 'T' || c == 'F' || c == '0' || c == '1' || c == '2') continue;
            throw new GeometryException("relation string");
        }
        int relation = RelationalOperationsMatrix.getPredefinedRelation_(scl, geometry_a.getDimension(), geometry_b.getDimension());
        if (relation != 0) {
            return RelationalOperations.relate(geometry_a, geometry_b, sr, relation, progress_tracker);
        }
        Envelope2D env1 = new Envelope2D();
        geometry_a.queryEnvelope2D(env1);
        Envelope2D env2 = new Envelope2D();
        geometry_b.queryEnvelope2D(env2);
        Envelope2D envMerged = new Envelope2D();
        envMerged.setCoords(env1);
        envMerged.merge(env2);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, envMerged, false);
        Geometry _geometryA = RelationalOperationsMatrix.convertGeometry_(geometry_a, tolerance);
        Geometry _geometryB = RelationalOperationsMatrix.convertGeometry_(geometry_b, tolerance);
        if (_geometryA.isEmpty() || _geometryB.isEmpty()) {
            return RelationalOperationsMatrix.relateEmptyGeometries_(_geometryA, _geometryB, scl);
        }
        int typeA = _geometryA.getType().value();
        int typeB = _geometryB.getType().value();
        boolean bRelation = false;
        block0 : switch (typeA) {
            case 1736: {
                switch (typeB) {
                    case 1736: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePolygon_((Polygon)_geometryA, (Polygon)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePolyline_((Polygon)_geometryA, (Polyline)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePoint_((Polygon)_geometryA, (Point)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperationsMatrix.polygonRelateMultiPoint_((Polygon)_geometryA, (MultiPoint)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 1607: {
                switch (typeB) {
                    case 1736: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePolyline_((Polygon)_geometryB, (Polyline)_geometryA, tolerance, RelationalOperationsMatrix.getTransposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperationsMatrix.polylineRelatePolyline_((Polyline)_geometryA, (Polyline)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperationsMatrix.polylineRelatePoint_((Polyline)_geometryA, (Point)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperationsMatrix.polylineRelateMultiPoint_((Polyline)_geometryA, (MultiPoint)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 33: {
                switch (typeB) {
                    case 1736: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePoint_((Polygon)_geometryB, (Point)_geometryA, tolerance, RelationalOperationsMatrix.getTransposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperationsMatrix.polylineRelatePoint_((Polyline)_geometryB, (Point)_geometryA, tolerance, RelationalOperationsMatrix.getTransposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperationsMatrix.pointRelatePoint_((Point)_geometryA, (Point)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperationsMatrix.multiPointRelatePoint_((MultiPoint)_geometryB, (Point)_geometryA, tolerance, RelationalOperationsMatrix.getTransposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 550: {
                switch (typeB) {
                    case 1736: {
                        bRelation = RelationalOperationsMatrix.polygonRelateMultiPoint_((Polygon)_geometryB, (MultiPoint)_geometryA, tolerance, RelationalOperationsMatrix.getTransposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperationsMatrix.polylineRelateMultiPoint_((Polyline)_geometryB, (MultiPoint)_geometryA, tolerance, RelationalOperationsMatrix.getTransposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperationsMatrix.multiPointRelateMultiPoint_((MultiPoint)_geometryA, (MultiPoint)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperationsMatrix.multiPointRelatePoint_((MultiPoint)_geometryA, (Point)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            default: {
                bRelation = false;
            }
        }
        return bRelation;
    }

    private RelationalOperationsMatrix() {
    }

    static boolean polygonRelatePolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setAreaAreaPredicates_();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polygon_b.queryEnvelope2D(env_b);
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.areaAreaDisjointPredicates_(polygon_a, polygon_b);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polygon_b, tolerance, false);
            if (relation == 4) {
                relOps.areaAreaDisjointPredicates_(polygon_a, polygon_b);
                bRelationKnown = true;
            } else if (relation == 1) {
                relOps.areaAreaContainsPredicates_(polygon_b);
                bRelationKnown = true;
            } else if (relation == 2) {
                relOps.areaAreaWithinPredicates_(polygon_a);
                bRelationKnown = true;
            }
        }
        if (!bRelationKnown) {
            EditShape edit_shape = new EditShape();
            int geom_a = edit_shape.addGeometry(polygon_a);
            int geom_b = edit_shape.addGeometry(polygon_b);
            relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
            relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
            relOps.m_topo_graph.removeShape();
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polygonContainsPolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progress_tracker) {
        boolean b_empty;
        assert (!polygon_a.isEmpty());
        assert (!polygon_b.isEmpty());
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_("T*****F**");
        relOps.setAreaAreaPredicates_();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polygon_b.queryEnvelope2D(env_b);
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.areaAreaDisjointPredicates_(polygon_a, polygon_b);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polygon_b, tolerance, false);
            if (relation == 4) {
                relOps.areaAreaDisjointPredicates_(polygon_a, polygon_b);
                bRelationKnown = true;
            } else if (relation == 1) {
                relOps.areaAreaContainsPredicates_(polygon_b);
                bRelationKnown = true;
            } else if (relation == 2) {
                relOps.areaAreaWithinPredicates_(polygon_a);
                bRelationKnown = true;
            }
        }
        if (bRelationKnown) {
            boolean bContains = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
            return bContains;
        }
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(polygon_a);
        int geom_b = edit_shape.addGeometry(polygon_b);
        CrackAndCluster.execute(edit_shape, tolerance, progress_tracker, false);
        Polyline boundary_b = (Polyline)edit_shape.getGeometry(geom_b).getBoundary();
        edit_shape.filterClosePoints(0.0, true, true);
        Simplificator.execute(edit_shape, geom_a, -1, false, progress_tracker);
        if (edit_shape.getPointCount(geom_a) == 0) {
            return false;
        }
        Simplificator.execute(edit_shape, geom_b, -1, false, progress_tracker);
        relOps.setEditShape_(edit_shape, progress_tracker);
        boolean bl = b_empty = edit_shape.getPointCount(geom_b) == 0;
        if (!b_empty) {
            relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
            relOps.m_topo_graph.removeShape();
            boolean bContains = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
            if (!bContains) {
                return bContains;
            }
        }
        Polygon polygon_simple_a = (Polygon)edit_shape.getGeometry(geom_a);
        edit_shape = new EditShape();
        geom_a = edit_shape.addGeometry(polygon_simple_a);
        geom_b = edit_shape.addGeometry(boundary_b);
        relOps.setEditShape_(edit_shape, progress_tracker);
        relOps.m_predicate_count = 0;
        relOps.resetMatrix_();
        relOps.setPredicates_(b_empty ? "T*****F**" : "******F**");
        relOps.setAreaLinePredicates_();
        relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
        relOps.m_topo_graph.removeShape();
        boolean bContains = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bContains;
    }

    static boolean polygonRelatePolyline_(Polygon polygon_a, Polyline polyline_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setAreaLinePredicates_();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polyline_b.queryEnvelope2D(env_b);
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.areaLineDisjointPredicates_(polygon_a, polyline_b);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polyline_b, tolerance, false);
            if (relation == 4) {
                relOps.areaLineDisjointPredicates_(polygon_a, polyline_b);
                bRelationKnown = true;
            } else if (relation == 1) {
                relOps.areaLineContainsPredicates_(polygon_a, polyline_b);
                bRelationKnown = true;
            }
        }
        if (!bRelationKnown) {
            EditShape edit_shape = new EditShape();
            int geom_a = edit_shape.addGeometry(polygon_a);
            int geom_b = edit_shape.addGeometry(polyline_b);
            relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
            relOps.m_cluster_index_b = relOps.m_topo_graph.createUserIndexForClusters();
            RelationalOperationsMatrix.markClusterEndPoints_(geom_b, relOps.m_topo_graph, relOps.m_cluster_index_b);
            relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
            relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_b);
            relOps.m_topo_graph.removeShape();
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polygonContainsPolyline_(Polygon polygon_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_("T*****F**");
        relOps.setAreaLinePredicates_();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polyline_b.queryEnvelope2D(env_b);
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.areaLineDisjointPredicates_(polygon_a, polyline_b);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polyline_b, tolerance, false);
            if (relation == 4) {
                relOps.areaLineDisjointPredicates_(polygon_a, polyline_b);
                bRelationKnown = true;
            } else if (relation == 1) {
                relOps.areaLineContainsPredicates_(polygon_a, polyline_b);
                bRelationKnown = true;
            }
        }
        if (bRelationKnown) {
            boolean bContains = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
            return bContains;
        }
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(polygon_a);
        int geom_b = edit_shape.addGeometry(polyline_b);
        relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
        if (edit_shape.getPointCount(geom_a) == 0) {
            return false;
        }
        relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
        relOps.m_topo_graph.removeShape();
        boolean bContains = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bContains;
    }

    static boolean polygonRelateMultiPoint_(Polygon polygon_a, MultiPoint multipoint_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setAreaPointPredicates_();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.areaPointDisjointPredicates_(polygon_a);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, multipoint_b, tolerance, false);
            if (relation == 4) {
                relOps.areaPointDisjointPredicates_(polygon_a);
                bRelationKnown = true;
            } else if (relation == 1) {
                relOps.areaPointContainsPredicates_(polygon_a);
                bRelationKnown = true;
            }
        }
        if (!bRelationKnown) {
            EditShape edit_shape = new EditShape();
            int geom_a = edit_shape.addGeometry(polygon_a);
            int geom_b = edit_shape.addGeometry(multipoint_b);
            relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
            relOps.computeMatrixTopoGraphClusters_(geom_a, geom_b);
            relOps.m_topo_graph.removeShape();
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polylineRelatePolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        int relation;
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setLineLinePredicates_();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        polyline_b.queryEnvelope2D(env_b);
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.lineLineDisjointPredicates_(polyline_a, polyline_b);
            bRelationKnown = true;
        }
        if (!bRelationKnown && (relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, polyline_b, tolerance, false)) == 4) {
            relOps.lineLineDisjointPredicates_(polyline_a, polyline_b);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            EditShape edit_shape = new EditShape();
            int geom_a = edit_shape.addGeometry(polyline_a);
            int geom_b = edit_shape.addGeometry(polyline_b);
            relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
            relOps.m_cluster_index_a = relOps.m_topo_graph.createUserIndexForClusters();
            relOps.m_cluster_index_b = relOps.m_topo_graph.createUserIndexForClusters();
            RelationalOperationsMatrix.markClusterEndPoints_(geom_a, relOps.m_topo_graph, relOps.m_cluster_index_a);
            RelationalOperationsMatrix.markClusterEndPoints_(geom_b, relOps.m_topo_graph, relOps.m_cluster_index_b);
            relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
            relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_a);
            relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_b);
            relOps.m_topo_graph.removeShape();
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polylineRelateMultiPoint_(Polyline polyline_a, MultiPoint multipoint_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        int relation;
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setLinePointPredicates_();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.linePointDisjointPredicates_(polyline_a);
            bRelationKnown = true;
        }
        if (!bRelationKnown && (relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, multipoint_b, tolerance, false)) == 4) {
            relOps.linePointDisjointPredicates_(polyline_a);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            EditShape edit_shape = new EditShape();
            int geom_a = edit_shape.addGeometry(polyline_a);
            int geom_b = edit_shape.addGeometry(multipoint_b);
            relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
            relOps.m_cluster_index_a = relOps.m_topo_graph.createUserIndexForClusters();
            RelationalOperationsMatrix.markClusterEndPoints_(geom_a, relOps.m_topo_graph, relOps.m_cluster_index_a);
            relOps.computeMatrixTopoGraphClusters_(geom_a, geom_b);
            relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_a);
            relOps.m_topo_graph.removeShape();
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean multiPointRelateMultiPoint_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setPointPointPredicates_();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.pointPointDisjointPredicates_();
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            EditShape edit_shape = new EditShape();
            int geom_a = edit_shape.addGeometry(multipoint_a);
            int geom_b = edit_shape.addGeometry(multipoint_b);
            relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
            relOps.computeMatrixTopoGraphClusters_(geom_a, geom_b);
            relOps.m_topo_graph.removeShape();
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polygonRelatePoint_(Polygon polygon_a, Point point_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setAreaPointPredicates_();
        Envelope2D env_a = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        Point2D pt_b = point_b.getXY();
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.pointDisjointEnvelope_(pt_b, env_a, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.areaPointDisjointPredicates_(polygon_a);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            PolygonUtils.PiPResult res = PolygonUtils.isPointInPolygon2D(polygon_a, pt_b, tolerance);
            if (res == PolygonUtils.PiPResult.PiPInside) {
                relOps.m_matrix[0] = 0;
                relOps.m_matrix[2] = 2;
                relOps.m_matrix[3] = -1;
                relOps.m_matrix[5] = 1;
                relOps.m_matrix[6] = -1;
            } else if (res == PolygonUtils.PiPResult.PiPBoundary) {
                relOps.m_matrix[6] = -1;
                double area = polygon_a.calculateArea2D();
                if (area != 0.0) {
                    relOps.m_matrix[0] = -1;
                    relOps.m_matrix[3] = 0;
                    relOps.m_matrix[2] = 2;
                    relOps.m_matrix[5] = 1;
                } else {
                    relOps.m_matrix[0] = 0;
                    relOps.m_matrix[3] = -1;
                    relOps.m_matrix[5] = -1;
                    Envelope2D env = new Envelope2D();
                    polygon_a.queryEnvelope2D(env);
                    relOps.m_matrix[2] = env.getHeight() == 0.0 && env.getWidth() == 0.0 ? -1 : 1;
                }
            } else {
                relOps.areaPointDisjointPredicates_(polygon_a);
            }
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, scl);
        return bRelation;
    }

    static boolean polylineRelatePoint_(Polyline polyline_a, Point point_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setLinePointPredicates_();
        Envelope2D env_a = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        Point2D pt_b = point_b.getXY();
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.pointDisjointEnvelope_(pt_b, env_a, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.linePointDisjointPredicates_(polyline_a);
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            MultiPoint boundary_a = null;
            boolean b_boundary_contains_point_known = false;
            boolean b_boundary_contains_point = false;
            if (relOps.m_perform_predicates[0] || relOps.m_perform_predicates[6]) {
                boolean b_intersects = RelationalOperations.linearPathIntersectsPoint_(polyline_a, pt_b, tolerance);
                if (b_intersects) {
                    if (relOps.m_perform_predicates[0]) {
                        boundary_a = (MultiPoint)Boundary.calculate(polyline_a, progress_tracker);
                        b_boundary_contains_point = !RelationalOperations.multiPointDisjointPointImpl_(boundary_a, pt_b, tolerance, progress_tracker);
                        b_boundary_contains_point_known = true;
                        relOps.m_matrix[0] = b_boundary_contains_point ? -1 : 0;
                    }
                    relOps.m_matrix[6] = -1;
                } else {
                    relOps.m_matrix[0] = -1;
                    relOps.m_matrix[6] = 0;
                }
            }
            if (relOps.m_perform_predicates[3]) {
                if (boundary_a != null && boundary_a.isEmpty()) {
                    relOps.m_matrix[3] = -1;
                } else {
                    if (!b_boundary_contains_point_known) {
                        if (boundary_a == null) {
                            boundary_a = (MultiPoint)Boundary.calculate(polyline_a, progress_tracker);
                        }
                        b_boundary_contains_point = !RelationalOperations.multiPointDisjointPointImpl_(boundary_a, pt_b, tolerance, progress_tracker);
                        b_boundary_contains_point_known = true;
                    }
                    int n = relOps.m_matrix[3] = b_boundary_contains_point ? 0 : -1;
                }
            }
            if (relOps.m_perform_predicates[5]) {
                if (boundary_a != null && boundary_a.isEmpty()) {
                    relOps.m_matrix[5] = -1;
                } else if (b_boundary_contains_point_known && !b_boundary_contains_point) {
                    relOps.m_matrix[5] = 0;
                } else {
                    if (boundary_a == null) {
                        boundary_a = (MultiPoint)Boundary.calculate(polyline_a, progress_tracker);
                    }
                    boolean b_boundary_equals_point = RelationalOperations.multiPointEqualsPoint_(boundary_a, point_b, tolerance, progress_tracker);
                    int n = relOps.m_matrix[5] = b_boundary_equals_point ? -1 : 0;
                }
            }
            if (relOps.m_perform_predicates[2]) {
                boolean b_has_length;
                boolean bl = b_has_length = polyline_a.calculateLength2D() != 0.0;
                if (b_has_length) {
                    relOps.m_matrix[2] = 1;
                } else {
                    MultiPoint interior_a = new MultiPoint(polyline_a.getDescription());
                    interior_a.add(polyline_a, 0, polyline_a.getPointCount());
                    boolean b_interior_equals_point = RelationalOperations.multiPointEqualsPoint_(interior_a, point_b, tolerance, progress_tracker);
                    relOps.m_matrix[2] = b_interior_equals_point ? -1 : 0;
                }
            }
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean multiPointRelatePoint_(MultiPoint multipoint_a, Point point_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setPointPointPredicates_();
        Envelope2D env_a = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        Point2D pt_b = point_b.getXY();
        boolean bRelationKnown = false;
        boolean b_disjoint = RelationalOperations.pointDisjointEnvelope_(pt_b, env_a, tolerance, progress_tracker);
        if (b_disjoint) {
            relOps.pointPointDisjointPredicates_();
            bRelationKnown = true;
        }
        if (!bRelationKnown) {
            boolean b_intersects = false;
            boolean b_multipoint_contained = true;
            double tolerance_sq = tolerance * tolerance;
            for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
                Point2D pt_a = multipoint_a.getXY(i);
                if (Point2D.sqrDistance(pt_a, pt_b) <= tolerance_sq) {
                    b_intersects = true;
                } else {
                    b_multipoint_contained = false;
                }
                if (b_intersects && !b_multipoint_contained) break;
            }
            if (b_intersects) {
                relOps.m_matrix[0] = 0;
                relOps.m_matrix[2] = !b_multipoint_contained ? 0 : -1;
                relOps.m_matrix[6] = -1;
            } else {
                relOps.m_matrix[0] = -1;
                relOps.m_matrix[2] = 0;
                relOps.m_matrix[6] = 0;
            }
        }
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, scl);
        return bRelation;
    }

    static boolean pointRelatePoint_(Point point_a, Point point_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        Point2D pt_a = point_a.getXY();
        Point2D pt_b = point_b.getXY();
        int[] matrix = new int[9];
        for (int i = 0; i < 9; ++i) {
            matrix[i] = -1;
        }
        if (Point2D.sqrDistance(pt_a, pt_b) <= tolerance * tolerance) {
            matrix[0] = 0;
        } else {
            matrix[2] = 0;
            matrix[6] = 0;
        }
        matrix[8] = 2;
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(matrix, scl);
        return bRelation;
    }

    private static boolean relationCompare_(int[] matrix, String scl) {
        block7: for (int i = 0; i < 9; ++i) {
            switch (scl.charAt(i)) {
                case 'T': {
                    assert (matrix[i] != -2);
                    if (matrix[i] != -1) continue block7;
                    return false;
                }
                case 'F': {
                    assert (matrix[i] != -2);
                    if (matrix[i] == -1) continue block7;
                    return false;
                }
                case '0': {
                    assert (matrix[i] != -2);
                    if (matrix[i] == 0) continue block7;
                    return false;
                }
                case '1': {
                    assert (matrix[i] != -2);
                    if (matrix[i] == 1) continue block7;
                    return false;
                }
                case '2': {
                    assert (matrix[i] != -2);
                    if (matrix[i] == 2) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    static boolean relateEmptyGeometries_(Geometry geometry_a, Geometry geometry_b, String scl) {
        Geometry g_a;
        int[] matrix = new int[9];
        if (geometry_a.isEmpty() && geometry_b.isEmpty()) {
            for (int i = 0; i < 9; ++i) {
                matrix[i] = -1;
            }
            return RelationalOperationsMatrix.relationCompare_(matrix, scl);
        }
        boolean b_transpose = false;
        if (!geometry_a.isEmpty()) {
            g_a = geometry_a;
            Geometry g_b = geometry_b;
        } else {
            g_a = geometry_b;
            Geometry g_b = geometry_a;
            b_transpose = true;
        }
        matrix[0] = -1;
        matrix[1] = -1;
        matrix[3] = -1;
        matrix[4] = -1;
        matrix[6] = -1;
        matrix[7] = -1;
        matrix[8] = 2;
        int type = g_a.getType().value();
        if (Geometry.isMultiPath(type)) {
            if (type == 1736) {
                double area = ((Polygon)g_a).calculateArea2D();
                if (area != 0.0) {
                    matrix[2] = 2;
                    matrix[5] = 1;
                } else {
                    matrix[5] = -1;
                    Envelope2D env = new Envelope2D();
                    g_a.queryEnvelope2D(env);
                    matrix[2] = env.getHeight() == 0.0 && env.getWidth() == 0.0 ? 0 : 1;
                }
            } else {
                boolean b_has_length = ((Polyline)g_a).calculateLength2D() != 0.0;
                matrix[2] = b_has_length ? 1 : 0;
                matrix[5] = Boundary.hasNonEmptyBoundary((Polyline)g_a, null) ? 0 : -1;
            }
        } else {
            matrix[2] = 0;
            matrix[5] = -1;
        }
        if (b_transpose) {
            RelationalOperationsMatrix.transposeMatrix_(matrix);
        }
        return RelationalOperationsMatrix.relationCompare_(matrix, scl);
    }

    private static int getPredefinedRelation_(String scl, int dim_a, int dim_b) {
        if (RelationalOperationsMatrix.equals_(scl)) {
            return 3;
        }
        if (RelationalOperationsMatrix.disjoint_(scl)) {
            return 4;
        }
        if (RelationalOperationsMatrix.touches_(scl, dim_a, dim_b)) {
            return 8;
        }
        if (RelationalOperationsMatrix.crosses_(scl, dim_a, dim_b)) {
            return 16;
        }
        if (RelationalOperationsMatrix.contains_(scl)) {
            return 1;
        }
        if (RelationalOperationsMatrix.overlaps_(scl, dim_a, dim_b)) {
            return 32;
        }
        return 0;
    }

    private static boolean equals_(String scl) {
        return scl.charAt(0) == 'T' && scl.charAt(1) == '*' && scl.charAt(2) == 'F' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == 'F' && scl.charAt(6) == 'F' && scl.charAt(7) == 'F' && scl.charAt(8) == '*';
    }

    private static boolean disjoint_(String scl) {
        return scl.charAt(0) == 'F' && scl.charAt(1) == 'F' && scl.charAt(2) == '*' && scl.charAt(3) == 'F' && scl.charAt(4) == 'F' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
    }

    private static boolean touches_(String scl, int dim_a, int dim_b) {
        if (dim_a == 0 && dim_b == 0) {
            return false;
        }
        if (dim_a != 2 || dim_b != 2) {
            if (scl.charAt(0) == 'F' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == 'T' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*') {
                return true;
            }
            if (dim_a == 1 && dim_b == 1 && scl.charAt(0) == 'F' && scl.charAt(1) == 'T' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*') {
                return true;
            }
        }
        return dim_b != 0 && scl.charAt(0) == 'F' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == 'T' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
    }

    private static boolean crosses_(String scl, int dim_a, int dim_b) {
        if (dim_a > dim_b) {
            return scl.charAt(0) == 'T' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == 'T' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
        }
        return dim_a == 1 && dim_b == 1 && scl.charAt(0) == '0' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
    }

    private static boolean contains_(String scl) {
        return scl.charAt(0) == 'T' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == 'F' && scl.charAt(7) == 'F' && scl.charAt(8) == '*';
    }

    private static boolean overlaps_(String scl, int dim_a, int dim_b) {
        if (dim_a == dim_b) {
            if (dim_a != 1) {
                return scl.charAt(0) == 'T' && scl.charAt(1) == '*' && scl.charAt(2) == 'T' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == 'T' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
            }
            if (scl.charAt(0) == '1' && scl.charAt(1) == '*' && scl.charAt(2) == 'T' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == 'T' && scl.charAt(7) == '*' && scl.charAt(8) == '*') {
                return true;
            }
        }
        return false;
    }

    private static void markClusterEndPoints_(int geometry, TopoGraph topoGraph, int clusterIndex) {
        int id = topoGraph.getGeometryID(geometry);
        int cluster = topoGraph.getFirstCluster();
        while (cluster != -1) {
            int cluster_parentage = topoGraph.getClusterParentage(cluster);
            if ((cluster_parentage & id) != 0) {
                int first_half_edge = topoGraph.getClusterHalfEdge(cluster);
                if (first_half_edge == -1) {
                    topoGraph.setClusterUserIndex(cluster, clusterIndex, 0);
                } else {
                    int half_edge;
                    int next_half_edge = first_half_edge;
                    int index = 0;
                    do {
                        int half_edge_parentage;
                        if (((half_edge_parentage = topoGraph.getHalfEdgeParentage(half_edge = next_half_edge)) & id) == 0) continue;
                        ++index;
                    } while ((next_half_edge = topoGraph.getHalfEdgeNext(topoGraph.getHalfEdgeTwin(half_edge))) != first_half_edge);
                    topoGraph.setClusterUserIndex(cluster, clusterIndex, index);
                }
            }
            cluster = topoGraph.getNextCluster(cluster);
        }
    }

    private static String getTransposeMatrix_(String scl) {
        String transpose = new String();
        transpose = transpose + scl.charAt(0);
        transpose = transpose + scl.charAt(3);
        transpose = transpose + scl.charAt(6);
        transpose = transpose + scl.charAt(1);
        transpose = transpose + scl.charAt(4);
        transpose = transpose + scl.charAt(7);
        transpose = transpose + scl.charAt(2);
        transpose = transpose + scl.charAt(5);
        transpose = transpose + scl.charAt(8);
        return transpose;
    }

    private void resetMatrix_() {
        for (int i = 0; i < 9; ++i) {
            this.m_matrix[i] = -2;
            this.m_max_dim[i] = -2;
        }
    }

    private static void transposeMatrix_(int[] matrix) {
        int temp1 = matrix[1];
        int temp2 = matrix[2];
        int temp5 = matrix[5];
        matrix[1] = matrix[3];
        matrix[2] = matrix[6];
        matrix[5] = matrix[7];
        matrix[3] = temp1;
        matrix[6] = temp2;
        matrix[7] = temp5;
    }

    private void setPredicates_(String scl) {
        this.m_scl = scl;
        for (int i = 0; i < 9; ++i) {
            if (this.m_scl.charAt(i) != '*') {
                this.m_perform_predicates[i] = true;
                ++this.m_predicate_count;
                continue;
            }
            this.m_perform_predicates[i] = false;
        }
    }

    private void setRemainingPredicatesToFalse_() {
        for (int i = 0; i < 9; ++i) {
            if (!this.m_perform_predicates[i] || this.m_matrix[i] != -2) continue;
            this.m_matrix[i] = -1;
            this.m_perform_predicates[i] = false;
        }
    }

    private boolean isPredicateKnown_(int predicate) {
        assert (this.m_scl.charAt(predicate) != '*');
        if (this.m_matrix[predicate] == -2) {
            return false;
        }
        if (this.m_matrix[predicate] == -1) {
            this.m_perform_predicates[predicate] = false;
            --this.m_predicate_count;
            return true;
        }
        if (this.m_scl.charAt(predicate) != 'T' && this.m_scl.charAt(predicate) != 'F') {
            if (this.m_matrix[predicate] < this.m_max_dim[predicate]) {
                return false;
            }
            this.m_perform_predicates[predicate] = false;
            --this.m_predicate_count;
            return true;
        }
        this.m_perform_predicates[predicate] = false;
        --this.m_predicate_count;
        return true;
    }

    private void setAreaAreaPredicates_() {
        this.m_predicates_half_edge = 0;
        this.m_max_dim[0] = 2;
        this.m_max_dim[1] = 1;
        this.m_max_dim[2] = 2;
        this.m_max_dim[3] = 1;
        this.m_max_dim[4] = 1;
        this.m_max_dim[5] = 1;
        this.m_max_dim[6] = 2;
        this.m_max_dim[7] = 1;
        this.m_max_dim[8] = 2;
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setAreaLinePredicates_() {
        this.m_predicates_half_edge = 1;
        this.m_predicates_cluster = 3;
        this.m_max_dim[0] = 1;
        this.m_max_dim[1] = 0;
        this.m_max_dim[2] = 2;
        this.m_max_dim[3] = 1;
        this.m_max_dim[4] = 0;
        this.m_max_dim[5] = 1;
        this.m_max_dim[6] = 1;
        this.m_max_dim[7] = 0;
        this.m_max_dim[8] = 2;
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setLineLinePredicates_() {
        this.m_predicates_half_edge = 2;
        this.m_predicates_cluster = 4;
        this.m_max_dim[0] = 1;
        this.m_max_dim[1] = 0;
        this.m_max_dim[2] = 1;
        this.m_max_dim[3] = 0;
        this.m_max_dim[4] = 0;
        this.m_max_dim[5] = 0;
        this.m_max_dim[6] = 1;
        this.m_max_dim[7] = 0;
        this.m_max_dim[8] = 2;
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setAreaPointPredicates_() {
        this.m_predicates_cluster = 3;
        this.m_max_dim[0] = 0;
        this.m_max_dim[1] = -1;
        this.m_max_dim[2] = 2;
        this.m_max_dim[3] = 0;
        this.m_max_dim[4] = -1;
        this.m_max_dim[5] = 1;
        this.m_max_dim[6] = 0;
        this.m_max_dim[7] = -1;
        this.m_max_dim[8] = 2;
        if (this.m_perform_predicates[1]) {
            this.m_matrix[1] = -1;
            this.m_perform_predicates[1] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[4]) {
            this.m_matrix[4] = -1;
            this.m_perform_predicates[4] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[7]) {
            this.m_matrix[7] = -1;
            this.m_perform_predicates[7] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setLinePointPredicates_() {
        this.m_predicates_cluster = 4;
        this.m_max_dim[0] = 0;
        this.m_max_dim[1] = -1;
        this.m_max_dim[2] = 1;
        this.m_max_dim[3] = 0;
        this.m_max_dim[4] = -1;
        this.m_max_dim[5] = 0;
        this.m_max_dim[6] = 0;
        this.m_max_dim[7] = -1;
        this.m_max_dim[8] = 2;
        if (this.m_perform_predicates[1]) {
            this.m_matrix[1] = -1;
            this.m_perform_predicates[1] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[4]) {
            this.m_matrix[4] = -1;
            this.m_perform_predicates[4] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[7]) {
            this.m_matrix[7] = -1;
            this.m_perform_predicates[7] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setPointPointPredicates_() {
        this.m_predicates_cluster = 5;
        this.m_max_dim[0] = 0;
        this.m_max_dim[1] = -1;
        this.m_max_dim[2] = 0;
        this.m_max_dim[3] = -1;
        this.m_max_dim[4] = -1;
        this.m_max_dim[5] = -1;
        this.m_max_dim[6] = 0;
        this.m_max_dim[7] = -1;
        this.m_max_dim[8] = 2;
        if (this.m_perform_predicates[1]) {
            this.m_matrix[1] = -1;
            this.m_perform_predicates[1] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[3]) {
            this.m_matrix[3] = -1;
            this.m_perform_predicates[3] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[4]) {
            this.m_matrix[4] = -1;
            this.m_perform_predicates[4] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[5]) {
            this.m_matrix[5] = -1;
            this.m_perform_predicates[5] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[7]) {
            this.m_matrix[7] = -1;
            this.m_perform_predicates[7] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private boolean areaAreaPredicates_(int half_edge, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorAreaInteriorArea_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(0);
        }
        if (this.m_perform_predicates[1]) {
            this.interiorAreaBoundaryArea_(half_edge, id_a, 1);
            bRelationKnown &= this.isPredicateKnown_(1);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorAreaExteriorArea_(half_edge, id_a, id_b, 2);
            bRelationKnown &= this.isPredicateKnown_(2);
        }
        if (this.m_perform_predicates[3]) {
            this.interiorAreaBoundaryArea_(half_edge, id_b, 3);
            bRelationKnown &= this.isPredicateKnown_(3);
        }
        if (this.m_perform_predicates[4]) {
            this.boundaryAreaBoundaryArea_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(4);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryAreaExteriorArea_(half_edge, id_a, id_b, 5);
            bRelationKnown &= this.isPredicateKnown_(5);
        }
        if (this.m_perform_predicates[6]) {
            this.interiorAreaExteriorArea_(half_edge, id_b, id_a, 6);
            bRelationKnown &= this.isPredicateKnown_(6);
        }
        if (this.m_perform_predicates[7]) {
            this.boundaryAreaExteriorArea_(half_edge, id_b, id_a, 7);
            bRelationKnown &= this.isPredicateKnown_(7);
        }
        return bRelationKnown;
    }

    private void areaAreaDisjointPredicates_(Polygon polygon_a, Polygon polygon_b) {
        this.m_matrix[0] = -1;
        this.m_matrix[1] = -1;
        this.m_matrix[3] = -1;
        this.m_matrix[4] = -1;
        this.areaGeomContainsOrDisjointPredicates_(polygon_a, this.m_perform_predicates[2] ? 2 : -1, this.m_scl.charAt(2), this.m_perform_predicates[5] ? 5 : -1, this.m_scl.charAt(5));
        this.areaGeomContainsOrDisjointPredicates_(polygon_b, this.m_perform_predicates[6] ? 6 : -1, this.m_scl.charAt(6), this.m_perform_predicates[7] ? 7 : -1, this.m_scl.charAt(7));
    }

    private void areaGeomContainsOrDisjointPredicates_(Polygon polygon, int matrix_interior, char c1, int matrix_boundary, char c2) {
        if (matrix_interior != -1 || matrix_boundary != -1) {
            boolean has_area;
            boolean bl = c1 != 'T' && c1 != 'F' && matrix_interior != -1 || c2 != 'T' && c2 != 'F' && matrix_boundary != -1 ? polygon.calculateArea2D() != 0.0 : (has_area = true);
            if (has_area) {
                if (matrix_interior != -1) {
                    this.m_matrix[matrix_interior] = 2;
                }
                if (matrix_boundary != -1) {
                    this.m_matrix[matrix_boundary] = 1;
                }
            } else {
                if (matrix_boundary != -1) {
                    this.m_matrix[matrix_boundary] = -1;
                }
                if (matrix_interior != -1) {
                    Envelope2D env = new Envelope2D();
                    polygon.queryEnvelope2D(env);
                    this.m_matrix[matrix_interior] = env.getHeight() == 0.0 && env.getWidth() == 0.0 ? 0 : 1;
                }
            }
        }
    }

    private void areaAreaContainsPredicates_(Polygon polygon_b) {
        this.m_matrix[2] = 2;
        this.m_matrix[3] = -1;
        this.m_matrix[4] = -1;
        this.m_matrix[5] = 1;
        this.m_matrix[6] = -1;
        this.m_matrix[7] = -1;
        this.areaGeomContainsOrDisjointPredicates_(polygon_b, this.m_perform_predicates[0] ? 0 : -1, this.m_scl.charAt(0), this.m_perform_predicates[1] ? 1 : -1, this.m_scl.charAt(1));
    }

    private void areaAreaWithinPredicates_(Polygon polygon_a) {
        this.areaAreaContainsPredicates_(polygon_a);
        RelationalOperationsMatrix.transposeMatrix_(this.m_matrix);
    }

    private void areaLineDisjointPredicates_(Polygon polygon, Polyline polyline) {
        this.m_matrix[0] = -1;
        this.m_matrix[1] = -1;
        this.m_matrix[3] = -1;
        this.m_matrix[4] = -1;
        if (this.m_perform_predicates[6]) {
            char c = this.m_scl.charAt(6);
            boolean b_has_length = c != 'T' && c != 'F' ? polyline.calculateLength2D() != 0.0 : true;
            int n = this.m_matrix[6] = b_has_length ? 1 : 0;
        }
        if (this.m_perform_predicates[7]) {
            boolean has_non_empty_boundary = Boundary.hasNonEmptyBoundary(polyline, null);
            this.m_matrix[7] = has_non_empty_boundary ? 0 : -1;
        }
        this.areaGeomContainsOrDisjointPredicates_(polygon, this.m_perform_predicates[2] ? 2 : -1, this.m_scl.charAt(2), this.m_perform_predicates[5] ? 5 : -1, this.m_scl.charAt(5));
    }

    private void areaLineContainsPredicates_(Polygon polygon, Polyline polyline) {
        if (this.m_perform_predicates[0]) {
            char c = this.m_scl.charAt(0);
            boolean b_has_length = c != 'T' && c != 'F' ? polyline.calculateLength2D() != 0.0 : true;
            int n = this.m_matrix[0] = b_has_length ? 1 : 0;
        }
        if (this.m_perform_predicates[1]) {
            boolean has_non_empty_boundary = Boundary.hasNonEmptyBoundary(polyline, null);
            this.m_matrix[1] = has_non_empty_boundary ? 0 : -1;
        }
        this.m_matrix[2] = 2;
        this.m_matrix[3] = -1;
        this.m_matrix[4] = -1;
        this.m_matrix[5] = 1;
        this.m_matrix[6] = -1;
        this.m_matrix[7] = -1;
    }

    private void areaPointDisjointPredicates_(Polygon polygon) {
        this.m_matrix[0] = -1;
        this.m_matrix[3] = -1;
        this.m_matrix[6] = 0;
        this.areaGeomContainsOrDisjointPredicates_(polygon, this.m_perform_predicates[2] ? 2 : -1, this.m_scl.charAt(2), this.m_perform_predicates[5] ? 5 : -1, this.m_scl.charAt(5));
    }

    private void areaPointContainsPredicates_(Polygon polygon) {
        this.m_matrix[0] = 0;
        this.m_matrix[2] = 2;
        this.m_matrix[3] = -1;
        this.m_matrix[5] = 1;
        this.m_matrix[6] = -1;
    }

    private void lineLineDisjointPredicates_(Polyline polyline_a, Polyline polyline_b) {
        boolean b_has_length;
        char c;
        this.m_matrix[0] = -1;
        this.m_matrix[1] = -1;
        this.m_matrix[3] = -1;
        this.m_matrix[4] = -1;
        if (this.m_perform_predicates[2]) {
            c = this.m_scl.charAt(2);
            b_has_length = c != 'T' && c != 'F' ? polyline_a.calculateLength2D() != 0.0 : true;
            int n = this.m_matrix[2] = b_has_length ? 1 : 0;
        }
        if (this.m_perform_predicates[5]) {
            boolean has_non_empty_boundary_a = Boundary.hasNonEmptyBoundary(polyline_a, null);
            int n = this.m_matrix[5] = has_non_empty_boundary_a ? 0 : -1;
        }
        if (this.m_perform_predicates[6]) {
            c = this.m_scl.charAt(6);
            b_has_length = c != 'T' && c != 'F' ? polyline_b.calculateLength2D() != 0.0 : true;
            int n = this.m_matrix[6] = b_has_length ? 1 : 0;
        }
        if (this.m_perform_predicates[7]) {
            boolean has_non_empty_boundary_b = Boundary.hasNonEmptyBoundary(polyline_b, null);
            this.m_matrix[7] = has_non_empty_boundary_b ? 0 : -1;
        }
    }

    private void linePointDisjointPredicates_(Polyline polyline) {
        this.m_matrix[0] = -1;
        this.m_matrix[3] = -1;
        if (this.m_perform_predicates[2]) {
            char c = this.m_scl.charAt(2);
            boolean b_has_length = c != 'T' && c != 'F' ? polyline.calculateLength2D() != 0.0 : true;
            int n = this.m_matrix[2] = b_has_length ? 1 : 0;
        }
        if (this.m_perform_predicates[5]) {
            boolean has_non_empty_boundary = Boundary.hasNonEmptyBoundary(polyline, null);
            this.m_matrix[5] = has_non_empty_boundary ? 0 : -1;
        }
        this.m_matrix[6] = 0;
    }

    private void pointPointDisjointPredicates_() {
        this.m_matrix[0] = -1;
        this.m_matrix[2] = 0;
        this.m_matrix[6] = 0;
    }

    private boolean areaLinePredicates_(int half_edge, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorAreaInteriorLine_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(0);
        }
        if (this.m_perform_predicates[1]) {
            this.interiorAreaBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(1);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorAreaExteriorLine_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(2);
        }
        if (this.m_perform_predicates[3]) {
            this.boundaryAreaInteriorLine_(half_edge, id_a, id_b, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(3);
        }
        if (this.m_perform_predicates[4]) {
            this.boundaryAreaBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(4);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryAreaExteriorLine_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(5);
        }
        if (this.m_perform_predicates[6]) {
            this.exteriorAreaInteriorLine_(half_edge, id_a);
            bRelationKnown &= this.isPredicateKnown_(6);
        }
        if (this.m_perform_predicates[7]) {
            this.exteriorAreaBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(7);
        }
        return bRelationKnown;
    }

    private boolean lineLinePredicates_(int half_edge, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorLineInteriorLine_(half_edge, id_a, id_b, this.m_cluster_index_a, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(0);
        }
        if (this.m_perform_predicates[1]) {
            this.interiorLineBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_a, this.m_cluster_index_b, 1);
            bRelationKnown &= this.isPredicateKnown_(1);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorLineExteriorLine_(half_edge, id_a, id_b, 2);
            bRelationKnown &= this.isPredicateKnown_(2);
        }
        if (this.m_perform_predicates[3]) {
            this.interiorLineBoundaryLine_(half_edge, id_b, id_a, this.m_cluster_index_b, this.m_cluster_index_a, 3);
            bRelationKnown &= this.isPredicateKnown_(3);
        }
        if (this.m_perform_predicates[4]) {
            this.boundaryLineBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_a, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(4);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryLineExteriorLine_(half_edge, id_a, id_b, this.m_cluster_index_a, 5);
            bRelationKnown &= this.isPredicateKnown_(5);
        }
        if (this.m_perform_predicates[6]) {
            this.interiorLineExteriorLine_(half_edge, id_b, id_a, 6);
            bRelationKnown &= this.isPredicateKnown_(6);
        }
        if (this.m_perform_predicates[7]) {
            this.boundaryLineExteriorLine_(half_edge, id_b, id_a, this.m_cluster_index_b, 7);
            bRelationKnown &= this.isPredicateKnown_(7);
        }
        return bRelationKnown;
    }

    private boolean areaPointPredicates_(int cluster, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorAreaInteriorPoint_(cluster, id_a);
            bRelationKnown &= this.isPredicateKnown_(0);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorAreaExteriorPoint_(cluster, id_a);
            bRelationKnown &= this.isPredicateKnown_(2);
        }
        if (this.m_perform_predicates[3]) {
            this.boundaryAreaInteriorPoint_(cluster, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(3);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryAreaExteriorPoint_(cluster, id_a);
            bRelationKnown &= this.isPredicateKnown_(5);
        }
        if (this.m_perform_predicates[6]) {
            this.exteriorAreaInteriorPoint_(cluster, id_a);
            bRelationKnown &= this.isPredicateKnown_(6);
        }
        return bRelationKnown;
    }

    private boolean linePointPredicates_(int cluster, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorLineInteriorPoint_(cluster, id_a, id_b, this.m_cluster_index_a);
            bRelationKnown &= this.isPredicateKnown_(0);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorLineExteriorPoint_(cluster, id_a, id_b, this.m_cluster_index_a);
            bRelationKnown &= this.isPredicateKnown_(2);
        }
        if (this.m_perform_predicates[3]) {
            this.boundaryLineInteriorPoint_(cluster, id_a, id_b, this.m_cluster_index_a);
            bRelationKnown &= this.isPredicateKnown_(3);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryLineExteriorPoint_(cluster, id_a, id_b, this.m_cluster_index_a);
            bRelationKnown &= this.isPredicateKnown_(5);
        }
        if (this.m_perform_predicates[6]) {
            this.exteriorLineInteriorPoint_(cluster, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(6);
        }
        return bRelationKnown;
    }

    private boolean pointPointPredicates_(int cluster, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorPointInteriorPoint_(cluster, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(0);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorPointExteriorPoint_(cluster, id_a, id_b, 2);
            bRelationKnown &= this.isPredicateKnown_(2);
        }
        if (this.m_perform_predicates[6]) {
            this.interiorPointExteriorPoint_(cluster, id_b, id_a, 6);
            bRelationKnown &= this.isPredicateKnown_(6);
        }
        return bRelationKnown;
    }

    private void interiorAreaInteriorArea_(int half_edge, int id_a, int id_b) {
        if (this.m_matrix[0] == 2) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        if ((faceParentage & id_a) != 0 && (faceParentage & id_b) != 0) {
            this.m_matrix[0] = 2;
        }
    }

    private void interiorAreaBoundaryArea_(int half_edge, int id_a, int predicate) {
        if (this.m_matrix[predicate] == 1) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        int twinFaceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge));
        if ((faceParentage & id_a) != 0 && (twinFaceParentage & id_a) != 0) {
            this.m_matrix[predicate] = 1;
        }
    }

    private void interiorAreaExteriorArea_(int half_edge, int id_a, int id_b, int predicate) {
        if (this.m_matrix[predicate] == 2) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        if ((faceParentage & id_a) != 0 && (faceParentage & id_b) == 0) {
            this.m_matrix[predicate] = 2;
        }
    }

    private void boundaryAreaBoundaryArea_(int half_edge, int id_a, int id_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[4] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) != 0) {
            this.m_matrix[4] = 1;
            return;
        }
        if (this.m_matrix[4] != 0 && this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0 && (clusterParentage & id_b) != 0) {
            this.m_matrix[4] = 0;
        }
    }

    private void boundaryAreaExteriorArea_(int half_edge, int id_a, int id_b, int predicate) {
        if (this.m_matrix[predicate] == 1) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        int twinFaceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge));
        if ((faceParentage & id_b) == 0 && (twinFaceParentage & id_b) == 0) {
            this.m_matrix[predicate] = 1;
        }
    }

    private void interiorAreaInteriorLine_(int half_edge, int id_a, int id_b) {
        if (this.m_matrix[0] == 1) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        int twinFaceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge));
        if ((faceParentage & id_a) != 0 && (twinFaceParentage & id_a) != 0) {
            this.m_matrix[0] = 1;
        }
    }

    private void interiorAreaBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_b) {
        int faceParentage;
        int cluster;
        int clusterParentage;
        if (this.m_matrix[1] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) == 0 && ((faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge)) & id_a) != 0) {
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            if ((clusterParentage & id_b) != 0 && index % 2 != 0) {
                assert (index != -1);
                this.m_matrix[1] = 0;
            }
        }
    }

    private void interiorAreaExteriorLine_(int half_edge, int id_a, int id_b) {
        if (this.m_matrix[2] == 2) {
            return;
        }
        int half_edge_parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((half_edge_parentage & id_a) != 0) {
            this.m_matrix[2] = 2;
        }
    }

    private void boundaryAreaInteriorLine_(int half_edge, int id_a, int id_b, int cluster_index_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[3] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) != 0) {
            this.m_matrix[3] = 1;
            return;
        }
        if (this.m_matrix[3] != 0 && this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0) {
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            if ((clusterParentage & id_b) != 0 && index % 2 == 0) {
                assert (index != -1);
                this.m_matrix[3] = 0;
            }
        }
    }

    private void boundaryAreaBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[4] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0) {
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            if ((clusterParentage & id_b) != 0 && index % 2 != 0) {
                assert (index != -1);
                this.m_matrix[4] = 0;
            }
        }
    }

    private void boundaryAreaExteriorLine_(int half_edge, int id_a, int id_b) {
        if (this.m_matrix[5] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) == 0) {
            this.m_matrix[5] = 1;
        }
    }

    private void exteriorAreaInteriorLine_(int half_edge, int id_a) {
        if (this.m_matrix[6] == 1) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        int twinFaceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge));
        if ((faceParentage & id_a) == 0 && (twinFaceParentage & id_a) == 0) {
            this.m_matrix[6] = 1;
        }
    }

    private void exteriorAreaBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_b) {
        int faceParentage;
        int cluster;
        int clusterParentage;
        if (this.m_matrix[7] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) == 0 && ((faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge)) & id_a) == 0) {
            assert ((this.m_topo_graph.getHalfEdgeParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge)) & id_a) == 0);
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            if ((clusterParentage & id_b) != 0 && index % 2 != 0) {
                assert (index != -1);
                this.m_matrix[7] = 0;
            }
        }
    }

    private void interiorLineInteriorLine_(int half_edge, int id_a, int id_b, int cluster_index_a, int cluster_index_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[0] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) != 0) {
            this.m_matrix[0] = 1;
            return;
        }
        if (this.m_matrix[0] != 0 && this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0 && (clusterParentage & id_b) != 0) {
            int index_a = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a);
            int index_b = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            assert (index_a != -1);
            assert (index_b != -1);
            if (index_a % 2 == 0 && index_b % 2 == 0) {
                assert ((this.m_topo_graph.getClusterParentage(cluster) & id_a) != 0 && (this.m_topo_graph.getClusterParentage(cluster) & id_b) != 0);
                this.m_matrix[0] = 0;
            }
        }
    }

    private void interiorLineBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_a, int cluster_index_b, int predicate) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[predicate] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0 && (clusterParentage & id_b) != 0) {
            int index_a = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a);
            int index_b = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            assert (index_a != -1);
            assert (index_b != -1);
            if (index_a % 2 == 0 && index_b % 2 != 0) {
                assert ((this.m_topo_graph.getClusterParentage(cluster) & id_a) != 0 && (this.m_topo_graph.getClusterParentage(cluster) & id_b) != 0);
                this.m_matrix[predicate] = 0;
            }
        }
    }

    private void interiorLineExteriorLine_(int half_edge, int id_a, int id_b, int predicate) {
        if (this.m_matrix[predicate] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) == 0) {
            this.m_matrix[predicate] = 1;
        }
    }

    private void boundaryLineBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_a, int cluster_index_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[4] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0 && (clusterParentage & id_b) != 0) {
            int index_a = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a);
            int index_b = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            assert (index_a != -1);
            assert (index_b != -1);
            if (index_a % 2 != 0 && index_b % 2 != 0) {
                assert ((this.m_topo_graph.getClusterParentage(cluster) & id_a) != 0 && (this.m_topo_graph.getClusterParentage(cluster) & id_b) != 0);
                this.m_matrix[4] = 0;
            }
        }
    }

    private void boundaryLineExteriorLine_(int half_edge, int id_a, int id_b, int cluster_index_a, int predicate) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[predicate] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_b) == 0) {
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a);
            assert (index != -1);
            if (index % 2 != 0) {
                assert ((this.m_topo_graph.getClusterParentage(cluster) & id_a) != 0);
                this.m_matrix[predicate] = 0;
            }
        }
    }

    private void interiorAreaInteriorPoint_(int cluster, int id_a) {
        int chain;
        int chainParentage;
        if (this.m_matrix[0] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) == 0 && ((chainParentage = this.m_topo_graph.getChainParentage(chain = this.m_topo_graph.getClusterChain(cluster))) & id_a) != 0) {
            this.m_matrix[0] = 0;
        }
    }

    private void interiorAreaExteriorPoint_(int cluster, int id_a) {
        if (this.m_matrix[2] == 2) {
            return;
        }
        int cluster_parentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((cluster_parentage & id_a) != 0) {
            this.m_matrix[2] = 2;
        }
    }

    private void boundaryAreaInteriorPoint_(int cluster, int id_a, int id_b) {
        if (this.m_matrix[3] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) != 0) {
            this.m_matrix[3] = 0;
        }
    }

    private void boundaryAreaExteriorPoint_(int cluster, int id_a) {
        if (this.m_matrix[5] == 1) {
            return;
        }
        int cluster_parentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((cluster_parentage & id_a) != 0) {
            this.m_matrix[5] = 1;
        }
    }

    private void exteriorAreaInteriorPoint_(int cluster, int id_a) {
        int chain;
        int chainParentage;
        if (this.m_matrix[6] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) == 0 && ((chainParentage = this.m_topo_graph.getChainParentage(chain = this.m_topo_graph.getClusterChain(cluster))) & id_a) == 0) {
            this.m_matrix[6] = 0;
        }
    }

    private void interiorLineInteriorPoint_(int cluster, int id_a, int id_b, int cluster_index_a) {
        int index;
        if (this.m_matrix[0] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) != 0 && (index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a)) % 2 == 0) {
            this.m_matrix[0] = 0;
        }
    }

    private void interiorLineExteriorPoint_(int cluster, int id_a, int id_b, int cluster_index_a) {
        int clusterParentage;
        if (this.m_matrix[2] == 1) {
            return;
        }
        int half_edge_a = this.m_topo_graph.getClusterHalfEdge(cluster);
        if (half_edge_a != -1) {
            this.m_matrix[2] = 1;
            return;
        }
        if (this.m_matrix[2] != 0 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster)) & id_b) == 0) {
            assert (this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a) % 2 == 0);
            this.m_matrix[2] = 0;
            return;
        }
    }

    private void boundaryLineInteriorPoint_(int cluster, int id_a, int id_b, int cluster_index_a) {
        int index;
        if (this.m_matrix[3] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) != 0 && (index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a)) % 2 != 0) {
            this.m_matrix[3] = 0;
        }
    }

    private void boundaryLineExteriorPoint_(int cluster, int id_a, int id_b, int cluster_index_a) {
        int index;
        if (this.m_matrix[5] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) == 0 && (index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a)) % 2 != 0) {
            this.m_matrix[5] = 0;
        }
    }

    private void exteriorLineInteriorPoint_(int cluster, int id_a, int id_b) {
        if (this.m_matrix[6] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) == 0 && (clusterParentage & id_b) != 0) {
            this.m_matrix[6] = 0;
        }
    }

    private void interiorPointInteriorPoint_(int cluster, int id_a, int id_b) {
        if (this.m_matrix[0] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) != 0) {
            this.m_matrix[0] = 0;
        }
    }

    private void interiorPointExteriorPoint_(int cluster, int id_a, int id_b, int predicate) {
        if (this.m_matrix[predicate] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) == 0) {
            this.m_matrix[predicate] = 0;
        }
    }

    private void computeMatrixTopoGraphHalfEdges_(int geometry_a, int geometry_b) {
        boolean bRelationKnown = false;
        int id_a = this.m_topo_graph.getGeometryID(geometry_a);
        int id_b = this.m_topo_graph.getGeometryID(geometry_b);
        this.m_visited_index = this.m_topo_graph.createUserIndexForHalfEdges();
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            block14: {
                int half_edge;
                int first_half_edge;
                block13: {
                    first_half_edge = this.m_topo_graph.getClusterHalfEdge(cluster);
                    if (first_half_edge != -1) break block13;
                    if (this.m_predicates_cluster == -1) break block14;
                    switch (this.m_predicates_cluster) {
                        case 3: {
                            bRelationKnown = this.areaPointPredicates_(cluster, id_a, id_b);
                            break block14;
                        }
                        case 4: {
                            bRelationKnown = this.linePointPredicates_(cluster, id_a, id_b);
                            break block14;
                        }
                        default: {
                            throw GeometryException.GeometryInternalError();
                        }
                    }
                }
                int next_half_edge = first_half_edge;
                block10: do {
                    int visited;
                    if ((visited = this.m_topo_graph.getHalfEdgeUserIndex(half_edge = next_half_edge, this.m_visited_index)) == 1) continue;
                    do {
                        switch (this.m_predicates_half_edge) {
                            case 0: {
                                bRelationKnown = this.areaAreaPredicates_(half_edge, id_a, id_b);
                                break;
                            }
                            case 1: {
                                bRelationKnown = this.areaLinePredicates_(half_edge, id_a, id_b);
                                break;
                            }
                            case 2: {
                                bRelationKnown = this.lineLinePredicates_(half_edge, id_a, id_b);
                                break;
                            }
                            default: {
                                throw GeometryException.GeometryInternalError();
                            }
                        }
                        if (bRelationKnown) continue block10;
                        this.m_topo_graph.setHalfEdgeUserIndex(half_edge, this.m_visited_index, 1);
                    } while ((half_edge = this.m_topo_graph.getHalfEdgeNext(half_edge)) != next_half_edge && !bRelationKnown);
                } while (!bRelationKnown && (next_half_edge = this.m_topo_graph.getHalfEdgeNext(this.m_topo_graph.getHalfEdgeTwin(half_edge))) != first_half_edge);
                if (bRelationKnown) break;
            }
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        if (!bRelationKnown) {
            this.setRemainingPredicatesToFalse_();
        }
        this.m_topo_graph.deleteUserIndexForHalfEdges(this.m_visited_index);
    }

    private void computeMatrixTopoGraphClusters_(int geometry_a, int geometry_b) {
        boolean bRelationKnown = false;
        int id_a = this.m_topo_graph.getGeometryID(geometry_a);
        int id_b = this.m_topo_graph.getGeometryID(geometry_b);
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            switch (this.m_predicates_cluster) {
                case 3: {
                    bRelationKnown = this.areaPointPredicates_(cluster, id_a, id_b);
                    break;
                }
                case 4: {
                    bRelationKnown = this.linePointPredicates_(cluster, id_a, id_b);
                    break;
                }
                case 5: {
                    bRelationKnown = this.pointPointPredicates_(cluster, id_a, id_b);
                    break;
                }
                default: {
                    throw GeometryException.GeometryInternalError();
                }
            }
            if (bRelationKnown) break;
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        if (!bRelationKnown) {
            this.setRemainingPredicatesToFalse_();
        }
    }

    private void setEditShape_(EditShape shape, ProgressTracker progressTracker) {
        this.m_topo_graph.setEditShape(shape, progressTracker);
    }

    private void setEditShapeCrackAndCluster_(EditShape shape, double tolerance, ProgressTracker progress_tracker) {
        this.editShapeCrackAndCluster_(shape, tolerance, progress_tracker);
        this.setEditShape_(shape, progress_tracker);
    }

    private void editShapeCrackAndCluster_(EditShape shape, double tolerance, ProgressTracker progress_tracker) {
        CrackAndCluster.execute(shape, tolerance, progress_tracker, false);
        shape.filterClosePoints(0.0, true, true);
        int geometry = shape.getFirstGeometry();
        while (geometry != -1) {
            if (shape.getGeometryType(geometry) == Geometry.Type.Polygon.value()) {
                Simplificator.execute(shape, geometry, -1, false, progress_tracker);
            }
            geometry = shape.getNextGeometry(geometry);
        }
    }

    private static Geometry convertGeometry_(Geometry geometry, double tolerance) {
        int gt = geometry.getType().value();
        if (Geometry.isSegment(gt)) {
            Polyline polyline = new Polyline(geometry.getDescription());
            polyline.addSegment((Segment)geometry, true);
            return polyline;
        }
        if (gt == 197) {
            Envelope envelope = (Envelope)geometry;
            Envelope2D env = new Envelope2D();
            geometry.queryEnvelope2D(env);
            if (env.getHeight() <= tolerance && env.getWidth() <= tolerance) {
                Point point = new Point(geometry.getDescription());
                envelope.getCenter(point);
                return point;
            }
            if (env.getHeight() <= tolerance || env.getWidth() <= tolerance) {
                Polyline polyline = new Polyline(geometry.getDescription());
                Point p = new Point();
                envelope.queryCornerByVal(0, p);
                polyline.startPath(p);
                envelope.queryCornerByVal(2, p);
                polyline.lineTo(p);
                return polyline;
            }
            Polygon polygon = new Polygon(geometry.getDescription());
            polygon.addEnvelope(envelope, false);
            return polygon;
        }
        return geometry;
    }

    private static interface Predicates {
        public static final int AreaAreaPredicates = 0;
        public static final int AreaLinePredicates = 1;
        public static final int LineLinePredicates = 2;
        public static final int AreaPointPredicates = 3;
        public static final int LinePointPredicates = 4;
        public static final int PointPointPredicates = 5;
    }

    private static interface MatrixPredicate {
        public static final int InteriorInterior = 0;
        public static final int InteriorBoundary = 1;
        public static final int InteriorExterior = 2;
        public static final int BoundaryInterior = 3;
        public static final int BoundaryBoundary = 4;
        public static final int BoundaryExterior = 5;
        public static final int ExteriorInterior = 6;
        public static final int ExteriorBoundary = 7;
        public static final int ExteriorExterior = 8;
    }
}

