/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;

class StreamTable
extends JetTable {
    private final List<Expression<?>> argumentExpressions;

    StreamTable(SqlConnector sqlConnector, List<TableField> fields, String schemaName, String name, List<Expression<?>> argumentExpressions) {
        super(sqlConnector, fields, schemaName, name, (TableStatistics)new ConstantTableStatistics(Integer.MAX_VALUE));
        this.argumentExpressions = argumentExpressions;
    }

    StreamSource<JetSqlRow> items(Expression<Boolean> predicate, List<Expression<?>> projections) {
        List<Expression<?>> argumentExpressions = this.argumentExpressions;
        return SourceBuilder.stream((String)"stream", (FunctionEx & Serializable)ctx -> {
            ExpressionEvalContext evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)ctx);
            Integer rate = StreamTable.evaluate((Expression)argumentExpressions.get(0), evalContext);
            if (rate == null) {
                throw QueryException.error((String)"Invalid argument of a call to function GENERATE_STREAM - rate cannot be null");
            }
            if (rate < 0) {
                throw QueryException.error((String)"Invalid argument of a call to function GENERATE_STREAM - rate cannot be less than zero");
            }
            return new DataGenerator(rate, predicate, projections, evalContext);
        }).fillBufferFn((BiConsumerEx & Serializable)(rec$, x$0) -> ((DataGenerator)rec$).fillBuffer((SourceBuilder.SourceBuffer<JetSqlRow>)x$0)).build();
    }

    private static Integer evaluate(Expression<?> argumentExpression, ExpressionEvalContext evalContext) {
        if (argumentExpression == null) {
            return null;
        }
        return (Integer)argumentExpression.eval((Row)EmptyRow.INSTANCE, evalContext);
    }

    public PlanObjectKey getObjectKey() {
        return null;
    }

    private static final class DataGenerator {
        private static final int MAX_BATCH_SIZE = 1024;
        private static final long NANOS_PER_MICRO = TimeUnit.MICROSECONDS.toNanos(1L);
        private static final long MICROS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
        private final long startTime = System.nanoTime();
        private final int rate;
        private final Expression<Boolean> predicate;
        private final List<Expression<?>> projections;
        private final ExpressionEvalContext evalContext;
        private long sequence;

        private DataGenerator(int rate, Expression<Boolean> predicate, List<Expression<?>> projections, ExpressionEvalContext evalContext) {
            this.rate = rate;
            this.predicate = predicate;
            this.projections = projections;
            this.evalContext = evalContext;
        }

        private void fillBuffer(SourceBuilder.SourceBuffer<JetSqlRow> buffer) {
            long now = System.nanoTime();
            long emitValuesUpTo = (now - this.startTime) / NANOS_PER_MICRO * (long)this.rate / MICROS_PER_SECOND;
            for (int i = 0; i < 1024 && this.sequence < emitValuesUpTo; ++i) {
                JetSqlRow row = ExpressionUtil.evaluate(this.predicate, this.projections, new JetSqlRow((SerializationService)this.evalContext.getSerializationService(), new Object[]{this.sequence}), this.evalContext);
                if (row != null) {
                    buffer.add((Object)row);
                }
                ++this.sequence;
            }
        }
    }
}

