/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.sql.impl.connector.keyvalue.JavaClassNameResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.sql.impl.FieldsUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Stream;

public final class KvMetadataJavaResolver
implements KvMetadataResolver {
    public static final KvMetadataJavaResolver INSTANCE = new KvMetadataJavaResolver();

    private KvMetadataJavaResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.concat(Stream.of("java"), JavaClassNameResolver.formats());
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        Class<?> clazz = this.loadClass(isKey, options);
        return this.resolveFields(isKey, userFields, clazz);
    }

    public Stream<MappingField> resolveFields(boolean isKey, List<MappingField> userFields, Class<?> clazz) {
        QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(clazz);
        if (type != QueryDataType.OBJECT) {
            return this.resolvePrimitiveSchema(isKey, userFields, type);
        }
        return this.resolveObjectSchema(isKey, userFields, clazz);
    }

    private Stream<MappingField> resolvePrimitiveSchema(boolean isKey, List<MappingField> userFields, QueryDataType type) {
        return userFields.isEmpty() ? this.resolvePrimitiveField(isKey, type) : this.resolveAndValidatePrimitiveField(isKey, userFields, type);
    }

    private Stream<MappingField> resolvePrimitiveField(boolean isKey, QueryDataType type) {
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
        String externalName = path.toString();
        return Stream.of(new MappingField(name, type, externalName));
    }

    private Stream<MappingField> resolveAndValidatePrimitiveField(boolean isKey, List<MappingField> userFields, QueryDataType type) {
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
        String externalName = path.toString();
        MappingField userField = userFieldsByPath.get(path);
        if (userField != null && !userField.name().equals(name)) {
            throw QueryException.error((String)("Cannot rename field: '" + name + '\''));
        }
        if (userField != null && !type.getTypeFamily().equals((Object)userField.type().getTypeFamily())) {
            throw QueryException.error((String)("Mismatch between declared and resolved type for field '" + userField.name() + "'"));
        }
        for (MappingField field : userFieldsByPath.values()) {
            if (externalName.equals(field.externalName())) continue;
            throw QueryException.error((String)("The field '" + externalName + "' is of type " + type.getTypeFamily() + ", you can't map '" + field.externalName() + "' too"));
        }
        return userFieldsByPath.values().stream();
    }

    private Stream<MappingField> resolveObjectSchema(boolean isKey, List<MappingField> userFields, Class<?> clazz) {
        return userFields.isEmpty() ? this.resolveObjectFields(isKey, clazz) : this.resolveAndValidateObjectFields(isKey, userFields, clazz);
    }

    private Stream<MappingField> resolveObjectFields(boolean isKey, Class<?> clazz) {
        SortedMap fieldsInClass = FieldsUtil.resolveClass(clazz);
        if (fieldsInClass.isEmpty()) {
            String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
            return Stream.of(new MappingField(name, QueryDataType.OBJECT, name));
        }
        return fieldsInClass.entrySet().stream().map(classField -> {
            QueryPath path = new QueryPath((String)classField.getKey(), isKey);
            QueryDataType type = QueryDataTypeUtils.resolveTypeForClass((Class)((Class)classField.getValue()));
            String name = (String)classField.getKey();
            return new MappingField(name, type, path.toString());
        });
    }

    private Stream<MappingField> resolveAndValidateObjectFields(boolean isKey, List<MappingField> userFields, Class<?> clazz) {
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        for (Map.Entry classField : FieldsUtil.resolveClass(clazz).entrySet()) {
            QueryPath path = new QueryPath((String)classField.getKey(), isKey);
            QueryDataType type = QueryDataTypeUtils.resolveTypeForClass((Class)((Class)classField.getValue()));
            MappingField userField = userFieldsByPath.get(path);
            if (userField == null || type.getTypeFamily().equals((Object)userField.type().getTypeFamily())) continue;
            throw QueryException.error((String)("Mismatch between declared and resolved type for field '" + userField.name() + "'. Declared: " + userField.type().getTypeFamily() + ", resolved: " + type.getTypeFamily()));
        }
        return userFieldsByPath.values().stream();
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Class<?> clazz = this.loadClass(isKey, options);
        return this.resolveMetadata(isKey, resolvedFields, clazz);
    }

    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Class<?> clazz) {
        QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(clazz);
        Map<QueryPath, MappingField> fields = KvMetadataResolver.extractFields(resolvedFields, isKey);
        if (type != QueryDataType.OBJECT) {
            return this.resolvePrimitiveMetadata(isKey, resolvedFields, fields, type);
        }
        return this.resolveObjectMetadata(isKey, resolvedFields, fields, clazz);
    }

    private KvMetadata resolvePrimitiveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<QueryPath, MappingField> fieldsByPath, QueryDataType type) {
        ArrayList<TableField> fields = new ArrayList<TableField>();
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        MappingField field = fieldsByPath.get(path);
        if (field != null) {
            fields.add((TableField)new MapTableField(field.name(), field.type(), false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, type);
        return new KvMetadata(fields, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, PrimitiveUpsertTargetDescriptor.INSTANCE);
    }

    private KvMetadata resolveObjectMetadata(boolean isKey, List<MappingField> resolvedFields, Map<QueryPath, MappingField> fieldsByPath, Class<?> clazz) {
        SortedMap typesByNames = FieldsUtil.resolveClass(clazz);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        HashMap<String, String> typeNamesByPaths = new HashMap<String, String>();
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add((TableField)new MapTableField(name, type, false, path));
            if (path.getPath() == null || typesByNames.get(path.getPath()) == null) continue;
            typeNamesByPaths.put(path.getPath(), ((Class)typesByNames.get(path.getPath())).getName());
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        return new KvMetadata(fields, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, new PojoUpsertTargetDescriptor(clazz.getName(), typeNamesByPaths));
    }

    private Class<?> loadClass(boolean isKey, Map<String, String> options) {
        String className;
        String formatProperty = options.get(isKey ? "keyFormat" : "valueFormat");
        String classNameProperty = isKey ? "keyJavaClass" : "valueJavaClass";
        String string = className = "java".equals(formatProperty) ? options.get(classNameProperty) : JavaClassNameResolver.resolveClassName(formatProperty);
        if (className == null) {
            throw QueryException.error((String)("Unable to resolve table metadata. Missing '" + classNameProperty + "' option"));
        }
        try {
            return ReflectionUtils.loadClass((String)className);
        }
        catch (Exception e) {
            throw QueryException.error((String)("Unable to load class: '" + className + "'"), (Throwable)e);
        }
    }
}

