/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.type.converter.ToConverters;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Map;

public class KvProjector {
    private final QueryDataType[] types;
    private final UpsertTarget keyTarget;
    private final UpsertTarget valueTarget;
    private final UpsertInjector[] injectors;
    private final boolean failOnNulls;

    KvProjector(QueryPath[] paths, QueryDataType[] types, UpsertTarget keyTarget, UpsertTarget valueTarget, boolean failOnNulls) {
        Preconditions.checkTrue((paths.length == types.length ? 1 : 0) != 0, (String)"paths.length != types.length");
        this.types = types;
        this.keyTarget = keyTarget;
        this.valueTarget = valueTarget;
        this.injectors = KvProjector.createInjectors(paths, types, keyTarget, valueTarget);
        this.failOnNulls = failOnNulls;
    }

    private static UpsertInjector[] createInjectors(QueryPath[] paths, QueryDataType[] types, UpsertTarget keyTarget, UpsertTarget valueTarget) {
        UpsertInjector[] injectors = new UpsertInjector[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            UpsertTarget target = paths[i].isKey() ? keyTarget : valueTarget;
            injectors[i] = target.createInjector(paths[i].getPath(), types[i]);
        }
        return injectors;
    }

    public Map.Entry<Object, Object> project(JetSqlRow row) {
        Object value;
        this.keyTarget.init();
        this.valueTarget.init();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            value = ToConverters.getToConverter(this.types[i]).convert(row.get(i));
            this.injectors[i].set(value);
        }
        Object key = this.keyTarget.conclude();
        if (key == null && this.failOnNulls) {
            throw QueryException.error((String)"Cannot write NULL to '__key' field. Note that NULL is used also if your INSERT/SINK command doesn't write to '__key' at all.");
        }
        value = this.valueTarget.conclude();
        if (value == null && this.failOnNulls) {
            throw QueryException.error((String)"Cannot write NULL to 'this' field. Note that NULL is used also if your INSERT/SINK command doesn't write to 'this' at all.");
        }
        return Util.entry((Object)key, (Object)value);
    }

    public static Supplier supplier(QueryPath[] paths, QueryDataType[] types, UpsertTargetDescriptor keyDescriptor, UpsertTargetDescriptor valueDescriptor, boolean failOnNulls) {
        return new Supplier(paths, types, keyDescriptor, valueDescriptor, failOnNulls);
    }

    public static final class Supplier
    implements DataSerializable {
        private QueryPath[] paths;
        private QueryDataType[] types;
        private UpsertTargetDescriptor keyDescriptor;
        private UpsertTargetDescriptor valueDescriptor;
        private boolean failOnNulls;

        private Supplier() {
        }

        private Supplier(QueryPath[] paths, QueryDataType[] types, UpsertTargetDescriptor keyDescriptor, UpsertTargetDescriptor valueDescriptor, boolean failOnNulls) {
            this.paths = paths;
            this.types = types;
            this.keyDescriptor = keyDescriptor;
            this.valueDescriptor = valueDescriptor;
            this.failOnNulls = failOnNulls;
        }

        public KvProjector get(InternalSerializationService serializationService) {
            return new KvProjector(this.paths, this.types, this.keyDescriptor.create(serializationService), this.valueDescriptor.create(serializationService), this.failOnNulls);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.paths.length);
            for (QueryPath queryPath : this.paths) {
                out.writeObject((Object)queryPath);
            }
            out.writeInt(this.types.length);
            for (QueryPath queryPath : this.types) {
                out.writeObject((Object)queryPath);
            }
            out.writeObject((Object)this.keyDescriptor);
            out.writeObject((Object)this.valueDescriptor);
            out.writeBoolean(this.failOnNulls);
        }

        public void readData(ObjectDataInput in) throws IOException {
            int i;
            this.paths = new QueryPath[in.readInt()];
            for (i = 0; i < this.paths.length; ++i) {
                this.paths[i] = (QueryPath)in.readObject();
            }
            this.types = new QueryDataType[in.readInt()];
            for (i = 0; i < this.types.length; ++i) {
                this.types[i] = (QueryDataType)in.readObject();
            }
            this.keyDescriptor = (UpsertTargetDescriptor)in.readObject();
            this.valueDescriptor = (UpsertTargetDescriptor)in.readObject();
            this.failOnNulls = in.readBoolean();
        }
    }
}

