/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.com.fasterxml.jackson.jr.ob.JSON;
import com.hazelcast.com.google.common.cache.Cache;
import com.hazelcast.com.google.common.cache.CacheBuilder;
import com.hazelcast.org.jsfr.json.Collector;
import com.hazelcast.org.jsfr.json.DefaultErrorHandlingStrategy;
import com.hazelcast.org.jsfr.json.ErrorHandlingStrategy;
import com.hazelcast.org.jsfr.json.JacksonJrParser;
import com.hazelcast.org.jsfr.json.JsonSurfer;
import com.hazelcast.org.jsfr.json.ValueBox;
import com.hazelcast.org.jsfr.json.compiler.JsonPathCompiler;
import com.hazelcast.org.jsfr.json.exception.JsonSurfingException;
import com.hazelcast.org.jsfr.json.path.JsonPath;
import com.hazelcast.org.jsfr.json.provider.JacksonJrProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class JsonPathUtil {
    private static final long CACHE_SIZE = 50L;
    private static final ErrorHandlingStrategy ERROR_HANDLING_STRATEGY = new DefaultErrorHandlingStrategy(){

        @Override
        public void handleParsingException(Exception e) {
            throw new JsonSurfingException("Failed to parse JSON document", e);
        }
    };
    private static final JsonSurfer SURFER = new JsonSurfer(new JacksonJrParser(), JacksonJrProvider.INSTANCE, ERROR_HANDLING_STRATEGY);

    private JsonPathUtil() {
    }

    public static Cache<String, JsonPath> makePathCache() {
        return CacheBuilder.newBuilder().maximumSize(50L).build();
    }

    public static JsonPath compile(String path) {
        return JsonPathCompiler.compile(path);
    }

    public static Collection<Object> read(String json, JsonPath path) {
        Collector collector = SURFER.collector(json);
        ValueBox<Collection<Object>> box = collector.collectAll(path, Object.class);
        collector.exec();
        return box.get();
    }

    public static boolean isArray(Object value) {
        return value instanceof ArrayList;
    }

    public static boolean isObject(Object value) {
        return value instanceof Map;
    }

    public static boolean isArrayOrObject(Object value) {
        return JsonPathUtil.isArray(value) || JsonPathUtil.isObject(value);
    }

    public static String wrapToArray(Collection<Object> resultColl, boolean unconditionally) {
        if (resultColl.size() > 1) {
            return JsonPathUtil.serialize(resultColl);
        }
        if (resultColl.isEmpty()) {
            return "[]";
        }
        Object result = resultColl.iterator().next();
        String serializedResult = JsonPathUtil.serialize(result);
        if (unconditionally) {
            return "[" + serializedResult + "]";
        }
        return serializedResult;
    }

    public static String serialize(Object object) {
        try {
            return JSON.std.asString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

