/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.com.fasterxml.jackson.core.JsonFactory;
import com.hazelcast.com.fasterxml.jackson.core.JsonGenerator;
import com.hazelcast.com.fasterxml.jackson.core.TreeNode;
import com.hazelcast.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class JsonUpsertTarget
implements UpsertTarget {
    private static final JsonFactory JSON_FACTORY = new ObjectMapper().getFactory();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private JsonGenerator generator;

    JsonUpsertTarget() {
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        return value -> {
            try {
                if (value == null) {
                    this.generator.writeNullField(path);
                } else {
                    switch (type.getTypeFamily()) {
                        case BOOLEAN: {
                            this.generator.writeBooleanField(path, ((Boolean)value).booleanValue());
                            break;
                        }
                        case TINYINT: {
                            this.generator.writeNumberField(path, (short)((Byte)value).byteValue());
                            break;
                        }
                        case SMALLINT: {
                            this.generator.writeNumberField(path, ((Short)value).shortValue());
                            break;
                        }
                        case INTEGER: {
                            this.generator.writeNumberField(path, ((Integer)value).intValue());
                            break;
                        }
                        case BIGINT: {
                            this.generator.writeNumberField(path, ((Long)value).longValue());
                            break;
                        }
                        case REAL: {
                            this.generator.writeNumberField(path, ((Float)value).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            this.generator.writeNumberField(path, ((Double)value).doubleValue());
                            break;
                        }
                        case DECIMAL: 
                        case TIME: 
                        case DATE: 
                        case TIMESTAMP: 
                        case TIMESTAMP_WITH_TIME_ZONE: 
                        case VARCHAR: {
                            this.generator.writeStringField(path, (String)QueryDataType.VARCHAR.convert(value));
                            break;
                        }
                        case OBJECT: {
                            this.injectObject(path, value);
                            break;
                        }
                        default: {
                            throw QueryException.error((String)("Unsupported type: " + type));
                        }
                    }
                }
            }
            catch (IOException e) {
                throw ExceptionUtil.sneakyThrow((Throwable)e);
            }
        };
    }

    private void injectObject(String path, Object value) throws IOException {
        this.generator.writeFieldName(path);
        if (value == null) {
            this.generator.writeNull();
        } else if (value instanceof TreeNode) {
            this.generator.writeTree((TreeNode)value);
        } else if (value instanceof Map) {
            this.generator.writeObject(value);
        } else if (value instanceof Boolean) {
            this.generator.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            this.generator.writeNumber((short)((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.generator.writeNumber(((Short)value).shortValue());
        } else if (value instanceof Integer) {
            this.generator.writeNumber(((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.generator.writeNumber(((Long)value).longValue());
        } else if (value instanceof Float) {
            this.generator.writeNumber(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.generator.writeNumber(((Double)value).doubleValue());
        } else {
            this.generator.writeString((String)QueryDataType.VARCHAR.convert(value));
        }
    }

    @Override
    public void init() {
        this.baos.reset();
        try {
            this.generator = JSON_FACTORY.createGenerator((OutputStream)this.baos);
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    @Override
    public Object conclude() {
        try {
            this.generator.writeEndObject();
            this.generator.close();
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
        return this.baos.toByteArray();
    }
}

