/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpression;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ExpressionValues
implements Serializable {
    public abstract int size();

    public abstract Stream<JetSqlRow> toValues(ExpressionEvalContext var1);

    public static class TransformedExpressionValues
    extends ExpressionValues {
        private final Expression<Boolean> predicate;
        private final List<Expression<?>> projection;
        private final List<ExpressionValues> values;

        public TransformedExpressionValues(RexNode filter, List<RexNode> project, RelDataType tuplesType, List<ExpressionValues> values, QueryParameterMetadata parameterMetadata) {
            PlanNodeSchema schema = OptUtils.schema(tuplesType);
            RexVisitor<Expression<?>> converter = OptUtils.createRexToExpressionVisitor((PlanNodeFieldTypeProvider)schema, parameterMetadata);
            this.predicate = filter == null ? null : filter.accept(converter);
            this.projection = project == null ? null : Util.toList(project, node -> (Expression)node.accept(converter));
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.stream().mapToInt(ExpressionValues::size).sum();
        }

        @Override
        public Stream<JetSqlRow> toValues(ExpressionEvalContext context) {
            return this.values.stream().flatMap(vs -> ExpressionUtil.evaluate(this.predicate, this.projection, vs.toValues(context), context).stream());
        }

        public String toString() {
            return "{" + (this.predicate == null ? "" : "predicate=[" + this.predicate + "], ") + (this.projection == null ? "" : "projection=" + this.projection + ", ") + "values=" + this.values + "}";
        }
    }

    public static class SimpleExpressionValues
    extends ExpressionValues {
        private final List<List<? extends Expression<?>>> expressions;

        public SimpleExpressionValues(ImmutableList<ImmutableList<RexLiteral>> tuples) {
            this.expressions = tuples.stream().map(tuple -> tuple.stream().map(RexToExpression::convertLiteral).collect(Collectors.toList())).collect(Collectors.toList());
        }

        @Override
        public int size() {
            return this.expressions.size();
        }

        @Override
        public Stream<JetSqlRow> toValues(ExpressionEvalContext context) {
            return this.expressions.stream().map(es -> new JetSqlRow((SerializationService)context.getSerializationService(), (Object[])es.stream().map(e -> e.eval((Row)EmptyRow.INSTANCE, context)).toArray(Object[]::new)));
        }

        public String toString() {
            return "{expressions=" + this.expressions + "}";
        }
    }
}

