/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import java.util.Arrays;

public final class FilterIntoScanLogicalRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    private static final RelRule.Config CONFIG = RelRule.Config.EMPTY.withDescription(FilterIntoScanLogicalRule.class.getSimpleName()).withOperandSupplier(b0 -> b0.operand(Filter.class).trait(Conventions.LOGICAL).inputs(b1 -> b1.operand(FullScanLogicalRel.class).anyInputs()));
    public static final RelOptRule INSTANCE = new FilterIntoScanLogicalRule(CONFIG);

    private FilterIntoScanLogicalRule(RelRule.Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        FullScanLogicalRel scan = (FullScanLogicalRel)call.rel(1);
        HazelcastTable table = OptUtils.extractHazelcastTable(scan);
        RexNode existingCondition = table.getFilter();
        RexNode convertedCondition = OptUtils.inlineExpression(table.getProjects(), filter.getCondition());
        if (existingCondition != null) {
            convertedCondition = RexUtil.composeConjunction(scan.getCluster().getRexBuilder(), Arrays.asList(existingCondition, convertedCondition), true);
        }
        HazelcastRelOptTable convertedTable = OptUtils.createRelTable((HazelcastRelOptTable)scan.getTable(), table.withFilter(convertedCondition), scan.getCluster().getTypeFactory());
        FullScanLogicalRel rel = new FullScanLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), convertedTable, scan.eventTimePolicyProvider(), scan.watermarkedColumnIndex());
        call.transformTo(rel);
    }
}

