/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.JoinLogicalRel;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rel.rules.JoinCommuteRule;

final class JoinLogicalRule
extends ConverterRule {
    static final RelOptRule INSTANCE = new JoinLogicalRule();

    private JoinLogicalRule() {
        super(LogicalJoin.class, Convention.NONE, Conventions.LOGICAL, JoinLogicalRule.class.getSimpleName());
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalJoin join = (LogicalJoin)rel;
        if (join.getJoinType() == JoinRelType.RIGHT) {
            return JoinCommuteRule.swap(join, true);
        }
        return new JoinLogicalRel(join.getCluster(), OptUtils.toLogicalConvention(join.getTraitSet()), OptUtils.toLogicalInput(join.getLeft()), OptUtils.toLogicalInput(join.getRight()), join.getCondition(), join.getJoinType());
    }
}

