/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.SlidingWindow;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.sql.impl.QueryException;
import java.util.Collections;

public class SlidingWindowFilterTransposeRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    private static final RelRule.Config CONFIG = RelRule.Config.EMPTY.withDescription(SlidingWindowFilterTransposeRule.class.getSimpleName()).withOperandSupplier(b0 -> b0.operand(Filter.class).trait(Conventions.LOGICAL).inputs(b1 -> b1.operand(SlidingWindow.class).anyInputs()));
    public static final RelOptRule STREAMING_FILTER_TRANSPOSE = new SlidingWindowFilterTransposeRule(CONFIG);

    protected SlidingWindowFilterTransposeRule(RelRule.Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        final SlidingWindow sw = (SlidingWindow)call.rel(1);
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef ref) {
                int index = ref.getIndex();
                if (index == sw.windowStartIndex() || index == sw.windowEndIndex()) {
                    throw QueryException.error((String)"Can't apply filter criteria to window bounds");
                }
                return (Void)super.visitInputRef(ref);
            }
        };
        filter.getCondition().accept(visitor);
        Filter newFilter = filter.copy(filter.getTraitSet(), sw.getInput(), filter.getCondition());
        SlidingWindow topSW = (SlidingWindow)sw.copy(sw.getTraitSet(), Collections.singletonList(newFilter));
        call.transformTo(topSW);
    }
}

