/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.com.google.common.collect.Iterables;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.WatermarkPolicy;
import com.hazelcast.jet.core.function.ObjLongBiFunction;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.jet.sql.impl.aggregate.function.ImposeOrderFunction;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.WatermarkLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.Serializable;

final class WatermarkRules {
    static final RelOptRule IMPOSE_ORDER_INSTANCE = new ConverterRule(LogicalTableFunctionScan.class, scan -> WatermarkRules.extractImposeOrderFunction(scan) != null, (RelTrait)Convention.NONE, (RelTrait)Conventions.LOGICAL, WatermarkRules.class.getSimpleName() + "(Impose Order)"){

        @Override
        public RelNode convert(RelNode rel) {
            LogicalTableFunctionScan function = (LogicalTableFunctionScan)rel;
            return new WatermarkLogicalRel(function.getCluster(), OptUtils.toLogicalConvention(function.getTraitSet()), (RelNode)Iterables.getOnlyElement(Util.toList(function.getInputs(), OptUtils::toLogicalInput)), this.toEventTimePolicyProvider(function), this.orderingColumnFieldIndex(function));
        }

        private FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> toEventTimePolicyProvider(LogicalTableFunctionScan function) {
            int orderingColumnFieldIndex = this.orderingColumnFieldIndex(function);
            Expression<?> lagExpression = this.lagExpression(function);
            return (FunctionEx & Serializable)context -> {
                long lagMs = WindowUtils.extractMillis(lagExpression, context);
                return EventTimePolicy.eventTimePolicy((ToLongFunctionEx & Serializable)row -> WindowUtils.extractMillis(row.get(orderingColumnFieldIndex)), (ObjLongBiFunction & Serializable)(row, timestamp) -> row, (SupplierEx)WatermarkPolicy.limitingLag((long)lagMs), (long)lagMs, (long)0L, (long)60000L);
            };
        }

        private int orderingColumnFieldIndex(LogicalTableFunctionScan function) {
            return ((RexInputRef)((RexCall)WatermarkRules.extractOperand(function, 1)).getOperands().get(0)).getIndex();
        }

        private Expression<?> lagExpression(LogicalTableFunctionScan function) {
            QueryParameterMetadata parameterMetadata = ((HazelcastRelOptCluster)function.getCluster()).getParameterMetadata();
            RexToExpressionVisitor visitor = new RexToExpressionVisitor(PlanNodeFieldTypeProvider.FAILING_FIELD_TYPE_PROVIDER, parameterMetadata);
            return (Expression)WatermarkRules.extractOperand(function, 2).accept(visitor);
        }
    };
    static final RelOptRule WATERMARK_INTO_SCAN_INSTANCE = new RelOptRule(RelOptRule.operand(WatermarkLogicalRel.class, RelOptRule.operand(FullScanLogicalRel.class, RelOptRule.none()), new RelOptRuleOperand[0]), WatermarkRules.class.getSimpleName() + "(Watermark Into Scan)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            WatermarkLogicalRel logicalWatermark = (WatermarkLogicalRel)call.rel(0);
            FullScanLogicalRel logicalScan = (FullScanLogicalRel)call.rel(1);
            FullScanLogicalRel rel = new FullScanLogicalRel(logicalWatermark.getCluster(), logicalWatermark.getTraitSet(), logicalScan.getTable(), logicalWatermark.eventTimePolicyProvider(), logicalWatermark.watermarkedColumnIndex());
            call.transformTo(rel);
        }
    };

    private WatermarkRules() {
    }

    private static ImposeOrderFunction extractImposeOrderFunction(LogicalTableFunctionScan scan) {
        if (scan == null || !(scan.getCall() instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)scan.getCall();
        if (!(call.getOperator() instanceof ImposeOrderFunction)) {
            return null;
        }
        return (ImposeOrderFunction)call.getOperator();
    }

    private static RexNode extractOperand(LogicalTableFunctionScan function, int index) {
        return ((RexCall)function.getCall()).getOperands().get(index);
    }
}

