/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.metadata;

import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class WatermarkedFields
implements Serializable {
    private final Map<Integer, RexNode> propertiesByIndex;

    public WatermarkedFields(Map<Integer, RexNode> propertiesByIndex) {
        this.propertiesByIndex = Collections.unmodifiableMap(propertiesByIndex);
    }

    public WatermarkedFields merge(WatermarkedFields other) {
        if (other == null || other.propertiesByIndex.isEmpty()) {
            return this;
        }
        HashMap<Integer, RexNode> newPropertiesByIndex = new HashMap<Integer, RexNode>(this.propertiesByIndex);
        newPropertiesByIndex.putAll(other.propertiesByIndex);
        assert (this.propertiesByIndex.size() + other.propertiesByIndex.size() == newPropertiesByIndex.size());
        return new WatermarkedFields(newPropertiesByIndex);
    }

    @Nullable
    public Map.Entry<Integer, RexNode> findFirst(ImmutableBitSet indices) {
        for (Map.Entry<Integer, RexNode> entry : this.propertiesByIndex.entrySet()) {
            if (!indices.get(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.propertiesByIndex.isEmpty();
    }

    public Map<Integer, RexNode> getPropertiesByIndex() {
        return this.propertiesByIndex;
    }
}

