/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexResolver;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;

final class IndexScanMapPhysicalRule
extends RelRule<RelRule.Config> {
    private static final RelRule.Config RULE_CONFIG = RelRule.Config.EMPTY.withDescription(IndexScanMapPhysicalRule.class.getSimpleName()).withOperandSupplier(b -> b.operand(FullScanLogicalRel.class).trait(Conventions.LOGICAL).predicate(scan -> OptUtils.hasTableType(scan, PartitionedMapTable.class)).noInputs());
    static final RelOptRule INSTANCE = new IndexScanMapPhysicalRule();

    private IndexScanMapPhysicalRule() {
        super(RULE_CONFIG);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FullScanLogicalRel logicalScan = (FullScanLogicalRel)call.rel(0);
        PartitionedMapTable table = (PartitionedMapTable)IndexScanMapPhysicalRule.table(logicalScan);
        for (RelNode indexScan : IndexResolver.createIndexScans(logicalScan, table.getIndexes())) {
            call.transformTo(indexScan);
        }
    }

    private static <T extends Table> T table(FullScanLogicalRel scan) {
        return OptUtils.extractHazelcastTable(scan).getTarget();
    }
}

