/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.common;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastOperandTypeCheckerAware;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.HazelcastReturnTypeInference;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Static;

public class HazelcastDescriptorOperator
extends SqlOperator
implements HazelcastOperandTypeCheckerAware {
    private static final int PRECEDENCE = 100;
    private static final SqlReturnTypeInference RETURN_TYPE_INFERENCE = HazelcastReturnTypeInference.wrap(binding -> binding.getTypeFactory().createSqlType(SqlTypeName.COLUMN_LIST));

    public HazelcastDescriptorOperator() {
        super("DESCRIPTOR", SqlKind.DESCRIPTOR, 100, 100, RETURN_TYPE_INFERENCE, null, null);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return validator.getTypeFactory().createSqlType(SqlTypeName.COLUMN_LIST);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding binding, boolean throwOnFailure) {
        HazelcastCallBinding bindingOverride = this.prepareBinding(binding);
        return this.checkOperandTypes(bindingOverride, throwOnFailure);
    }

    private boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        for (SqlNode operand : binding.getCall().getOperandList()) {
            if (operand instanceof SqlIdentifier && ((SqlIdentifier)operand).isSimple()) continue;
            if (throwOnFailure) {
                throw SqlUtil.newContextException(operand.getParserPosition(), Static.RESOURCE.aliasMustBeSimpleIdentifier());
            }
            return false;
        }
        return true;
    }
}

