/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.com.google.common.collect.ImmutableMap;
import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.interpreter.BindableConvention;
import com.hazelcast.org.apache.calcite.interpreter.BindableRel;
import com.hazelcast.org.apache.calcite.interpreter.InterpretableRel;
import com.hazelcast.org.apache.calcite.interpreter.Node;
import com.hazelcast.org.apache.calcite.interpreter.Row;
import com.hazelcast.org.apache.calcite.interpreter.Sink;
import com.hazelcast.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterImpl;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.runtime.ArrayBindable;
import com.hazelcast.org.apache.calcite.runtime.Bindable;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public class EnumerableBindable
extends ConverterImpl
implements BindableRel {
    protected EnumerableBindable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), input);
    }

    @Override
    public EnumerableBindable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableBindable(this.getCluster(), EnumerableBindable.sole(inputs));
    }

    @Override
    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    @Override
    public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
        ImmutableMap<String, Object> map = ImmutableMap.of();
        Bindable bindable = EnumerableInterpretable.toBindable(map, null, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        return arrayBindable.bind(dataContext);
    }

    @Override
    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        return () -> {
            Sink sink = Objects.requireNonNull(implementor.relSinks.get(this), () -> "relSinks.get is null for " + this).get(0);
            Enumerable<@Nullable Object[]> enumerable = this.bind(implementor.dataContext);
            Enumerator<@Nullable T> enumerator = enumerable.enumerator();
            while (enumerator.moveNext()) {
                sink.send(Row.asCopy((Object[])enumerator.current()));
            }
        };
    }

    public static class EnumerableToBindableConverterRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(EnumerableRel.class, EnumerableConvention.INSTANCE, BindableConvention.INSTANCE, "EnumerableToBindableConverterRule").withRuleFactory(EnumerableToBindableConverterRule::new);

        protected EnumerableToBindableConverterRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            return new EnumerableBindable(rel.getCluster(), rel);
        }
    }
}

