/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableSort;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;

class EnumerableSortRule
extends ConverterRule {
    public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(Sort.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableSortRule").withRuleFactory(EnumerableSortRule::new);

    protected EnumerableSortRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public @Nullable RelNode convert(RelNode rel) {
        Sort sort = (Sort)rel;
        if (sort.offset != null || sort.fetch != null) {
            return null;
        }
        RelNode input = sort.getInput();
        return EnumerableSort.create(EnumerableSortRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE)), sort.getCollation(), null, null);
    }
}

