/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.plan.RelOptSchema;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.prepare.RelOptTableImpl;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelDistribution;
import com.hazelcast.org.apache.calcite.rel.RelDistributions;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelReferentialConstraint;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.schema.ColumnStrategy;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Collections;
import java.util.List;

public abstract class RelOptAbstractTable
implements RelOptTable {
    protected final RelOptSchema schema;
    protected final RelDataType rowType;
    protected final String name;

    protected RelOptAbstractTable(RelOptSchema schema, String name, RelDataType rowType) {
        this.schema = schema;
        this.name = name;
        this.rowType = rowType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getQualifiedName() {
        return ImmutableList.of(this.name);
    }

    @Override
    public double getRowCount() {
        return 100.0;
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    @Override
    public @Nullable List<RelCollation> getCollationList() {
        return Collections.emptyList();
    }

    @Override
    public @Nullable RelDistribution getDistribution() {
        return RelDistributions.BROADCAST_DISTRIBUTED;
    }

    public <T> @Nullable T unwrap(Class<T> clazz) {
        return clazz.isInstance(this) ? (T)clazz.cast(this) : null;
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        return false;
    }

    @Override
    public @Nullable List<ImmutableBitSet> getKeys() {
        return Collections.emptyList();
    }

    @Override
    public @Nullable List<RelReferentialConstraint> getReferentialConstraints() {
        return Collections.emptyList();
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        return LogicalTableScan.create(context.getCluster(), this, context.getTableHints());
    }

    @Override
    public @Nullable Expression getExpression(Class clazz) {
        return null;
    }

    @Override
    public RelOptTable extend(List<RelDataTypeField> extendedFields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ColumnStrategy> getColumnStrategies() {
        return RelOptTableImpl.columnStrategies(this);
    }
}

