/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.logical;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelDistributionTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelInput;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdCollation;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdDistribution;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.List;
import java.util.Set;

public final class LogicalCalc
extends Calc {
    public LogicalCalc(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode child, RexProgram program) {
        super(cluster, traitSet, hints, child, program);
    }

    @Deprecated
    public LogicalCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexProgram program) {
        this(cluster, traitSet, ImmutableList.of(), child, program);
    }

    public LogicalCalc(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), ImmutableList.of(), input.getInput(), RexProgram.create(input));
    }

    @Deprecated
    public LogicalCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traitSet, ImmutableList.of(), child, program);
        Util.discard(collationList);
    }

    public static LogicalCalc create(RelNode input, RexProgram program) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSet().replace(Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.calc(mq, input, program)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.calc(mq, input, program));
        return new LogicalCalc(cluster, traitSet, ImmutableList.of(), input, program);
    }

    @Override
    public LogicalCalc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new LogicalCalc(this.getCluster(), traitSet, this.hints, child, program);
    }

    @Override
    public void collectVariablesUsed(Set<CorrelationId> variableSet) {
        RelOptUtil.VariableUsedVisitor vuv = new RelOptUtil.VariableUsedVisitor(null);
        vuv.visitEach(this.program.getExprList());
        variableSet.addAll(vuv.variables);
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalCalc(this.getCluster(), this.traitSet, ImmutableList.copyOf(hintList), this.input, this.program);
    }
}

