/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.metadata;

import com.hazelcast.com.google.common.collect.ImmutableCollection;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Multimap;
import com.hazelcast.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.metadata.Metadata;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.org.apache.calcite.rel.metadata.NullSentinel;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.UnboundMetadata;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Deprecated
public class CachingRelMetadataProvider
implements RelMetadataProvider {
    private final Map<List, CacheEntry> cache = new HashMap<List, CacheEntry>();
    private final RelMetadataProvider underlyingProvider;
    private final RelOptPlanner planner;

    public CachingRelMetadataProvider(RelMetadataProvider underlyingProvider, RelOptPlanner planner) {
        this.underlyingProvider = underlyingProvider;
        this.planner = planner;
    }

    @Override
    @Deprecated
    public <M extends Metadata> @Nullable UnboundMetadata<M> apply(Class<? extends RelNode> relClass, Class<? extends M> metadataClass) {
        UnboundMetadata function = this.underlyingProvider.apply(relClass, metadataClass);
        if (function == null) {
            return null;
        }
        return (rel, mq) -> {
            Metadata metadata = (Metadata)Objects.requireNonNull(function.bind(rel, mq), () -> "metadata must not be null, relClass=" + relClass + ", metadataClass=" + metadataClass);
            return (Metadata)metadataClass.cast(Proxy.newProxyInstance(metadataClass.getClassLoader(), new Class[]{metadataClass}, (InvocationHandler)new CachingInvocationHandler(metadata)));
        };
    }

    @Override
    @Deprecated
    public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
        return this.underlyingProvider.handlers(def);
    }

    @Override
    public List<MetadataHandler<?>> handlers(Class<? extends MetadataHandler<?>> handlerClass) {
        return this.underlyingProvider.handlers(handlerClass);
    }

    private class CachingInvocationHandler
    implements InvocationHandler {
        private final Metadata metadata;

        CachingInvocationHandler(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(method);
            builder.add(this.metadata.rel());
            if (args != null) {
                for (Object arg : args) {
                    builder.add(NullSentinel.mask(arg));
                }
            }
            ImmutableCollection key = builder.build();
            long timestamp = CachingRelMetadataProvider.this.planner.getRelMetadataTimestamp(this.metadata.rel());
            CacheEntry entry = (CacheEntry)CachingRelMetadataProvider.this.cache.get(key);
            if (entry != null && timestamp == entry.timestamp) {
                return entry.result;
            }
            try {
                Object result = method.invoke((Object)this.metadata, args);
                if (result != null) {
                    entry = new CacheEntry();
                    entry.timestamp = timestamp;
                    entry.result = result;
                    CachingRelMetadataProvider.this.cache.put(key, entry);
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw Nullness.castNonNull(e.getCause());
            }
        }
    }

    private static class CacheEntry {
        long timestamp;
        @Nullable Object result;

        private CacheEntry() {
        }
    }
}

