/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.metadata;

import com.hazelcast.com.google.common.cache.CacheBuilder;
import com.hazelcast.com.google.common.cache.CacheLoader;
import com.hazelcast.com.google.common.cache.LoadingCache;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Multimap;
import com.hazelcast.com.google.common.util.concurrent.UncheckedExecutionException;
import com.hazelcast.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.org.apache.calcite.interpreter.JaninoRexCompiler;
import com.hazelcast.org.apache.calcite.linq4j.Ord;
import com.hazelcast.org.apache.calcite.linq4j.tree.Primitive;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.metadata.CyclicMetadataException;
import com.hazelcast.org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.DelegatingMetadataRel;
import com.hazelcast.org.apache.calcite.rel.metadata.Metadata;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.org.apache.calcite.rel.metadata.NullSentinel;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.metadata.UnboundMetadata;
import com.hazelcast.org.apache.calcite.rel.metadata.janino.DescriptiveCacheKey;
import com.hazelcast.org.apache.calcite.rel.metadata.janino.DispatchGenerator;
import com.hazelcast.org.apache.calcite.runtime.FlatLists;
import com.hazelcast.org.apache.calcite.util.ControlFlowException;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.org.codehaus.commons.compiler.CompileException;
import com.hazelcast.org.codehaus.commons.compiler.CompilerFactoryFactory;
import com.hazelcast.org.codehaus.commons.compiler.ICompilerFactory;
import com.hazelcast.org.codehaus.commons.compiler.ISimpleCompiler;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class JaninoRelMetadataProvider
implements RelMetadataProvider {
    private final RelMetadataProvider provider;
    public static final JaninoRelMetadataProvider DEFAULT = JaninoRelMetadataProvider.of(DefaultRelMetadataProvider.INSTANCE);
    private static final LoadingCache<Key, MetadataHandler<?>> HANDLERS = JaninoRelMetadataProvider.maxSize(CacheBuilder.newBuilder(), CalciteSystemProperty.METADATA_HANDLER_CACHE_MAXIMUM_SIZE.value()).build(CacheLoader.from(key -> JaninoRelMetadataProvider.generateCompileAndInstantiate(key.handlerClass, key.provider.handlers(key.handlerClass))));

    private JaninoRelMetadataProvider(RelMetadataProvider provider) {
        this.provider = provider;
    }

    public static JaninoRelMetadataProvider of(RelMetadataProvider provider) {
        if (provider instanceof JaninoRelMetadataProvider) {
            return (JaninoRelMetadataProvider)provider;
        }
        return new JaninoRelMetadataProvider(provider);
    }

    private static <K, V> CacheBuilder<K, V> maxSize(CacheBuilder<K, V> builder, int size) {
        if (size >= 0) {
            builder.maximumSize(size);
        }
        return builder;
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof JaninoRelMetadataProvider && ((JaninoRelMetadataProvider)obj).provider.equals(this.provider);
    }

    public int hashCode() {
        return 109 + this.provider.hashCode();
    }

    @Override
    @Deprecated
    public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relClass, Class<? extends M> metadataClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
        return this.provider.handlers(def);
    }

    @Override
    public List<MetadataHandler<?>> handlers(Class<? extends MetadataHandler<?>> handlerClass) {
        return this.provider.handlers(handlerClass);
    }

    private static <MH extends MetadataHandler<?>> MH generateCompileAndInstantiate(Class<MH> handlerClass, List<? extends MetadataHandler<? extends Metadata>> handlers) {
        LinkedHashSet<? extends MetadataHandler<? extends Metadata>> handlerSet = new LinkedHashSet<MetadataHandler<? extends Metadata>>(handlers);
        StringBuilder buff = new StringBuilder();
        String name = "GeneratedMetadata_" + JaninoRelMetadataProvider.simpleNameForHandler(handlerClass);
        LinkedHashMap handlerToName = new LinkedHashMap();
        for (MetadataHandler metadataHandler : handlerSet) {
            if (handlerToName.containsKey(metadataHandler)) continue;
            handlerToName.put(metadataHandler, "provider" + handlerToName.size());
        }
        for (Map.Entry entry : handlerToName.entrySet()) {
            buff.append("  public final ").append(((MetadataHandler)entry.getKey()).getClass().getName()).append(' ').append((String)entry.getValue()).append(";\n");
        }
        buff.append("  public ").append(name).append("(\n");
        for (Map.Entry entry : handlerToName.entrySet()) {
            buff.append("      ").append(((MetadataHandler)entry.getKey()).getClass().getName()).append(' ').append((String)entry.getValue()).append(",\n");
        }
        if (!handlerToName.isEmpty()) {
            buff.setLength(buff.length() - 2);
        }
        buff.append(") {\n");
        for (String string : handlerToName.values()) {
            buff.append("    this.").append(string).append(" = ").append(string).append(";\n");
        }
        buff.append("  }\n");
        JaninoRelMetadataProvider.getDefMethod(buff, handlerToName.values().stream().findFirst().orElse(null));
        DispatchGenerator dispatchGenerator = new DispatchGenerator(handlerToName);
        for (Ord<Method> ord : Ord.zip(handlerClass.getDeclaredMethods())) {
            JaninoRelMetadataProvider.cacheProperties(buff, (Method)ord.e, ord.i);
            JaninoRelMetadataProvider.generateCachedMethod(buff, (Method)ord.e, ord.i);
            dispatchGenerator.dispatchMethod(buff, (Method)ord.e, handlerSet);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(handlerToName.keySet());
        try {
            return JaninoRelMetadataProvider.compile(name, buff.toString(), handlerClass, arrayList);
        }
        catch (CompileException | IOException exception) {
            throw new RuntimeException("Error compiling:\n" + buff, exception);
        }
    }

    static void cacheProperties(StringBuilder buff, Method method, int methodIndex) {
        buff.append("  private final Object ");
        JaninoRelMetadataProvider.appendKeyName(buff, methodIndex);
        buff.append(" = new ").append(DescriptiveCacheKey.class.getName()).append("(\"").append(method.toString()).append("\");\n");
    }

    private static void appendKeyName(StringBuilder buff, int methodIndex) {
        buff.append("methodKey").append(methodIndex);
    }

    private static void getDefMethod(StringBuilder buff, @Nullable String handlerName) {
        buff.append("  public ").append(MetadataDef.class.getName()).append(" getDef() {\n");
        if (handlerName == null) {
            buff.append("    return null;");
        } else {
            buff.append("    return ").append(handlerName).append(".getDef();\n");
        }
        buff.append("  }\n");
    }

    private static void generateCachedMethod(StringBuilder buff, Method method, int methodIndex) {
        String delRelClass = DelegatingMetadataRel.class.getName();
        buff.append("  public ").append(method.getReturnType().getName()).append(" ").append(method.getName()).append("(\n").append("      ").append(RelNode.class.getName()).append(" r,\n").append("      ").append(RelMetadataQuery.class.getName()).append(" mq");
        JaninoRelMetadataProvider.paramList(buff, method).append(") {\n").append("    while (r instanceof ").append(delRelClass).append(") {\n").append("      r = ((").append(delRelClass).append(") r).getMetadataDelegateRel();\n").append("    }\n").append("    final java.util.List key = ").append((method.getParameterTypes().length < 4 ? FlatLists.class : ImmutableList.class).getName()).append(".of(");
        JaninoRelMetadataProvider.appendKeyName(buff, methodIndex);
        JaninoRelMetadataProvider.safeArgList(buff, method).append(");\n").append("    final Object v = mq.map.get(r, key);\n").append("    if (v != null) {\n").append("      if (v == ").append(NullSentinel.class.getName()).append(".ACTIVE) {\n").append("        throw new ").append(CyclicMetadataException.class.getName()).append("();\n").append("      }\n").append("      if (v == ").append(NullSentinel.class.getName()).append(".INSTANCE) {\n").append("        return null;\n").append("      }\n").append("      return (").append(method.getReturnType().getName()).append(") v;\n").append("    }\n").append("    mq.map.put(r, key,").append(NullSentinel.class.getName()).append(".ACTIVE);\n").append("    try {\n").append("      final ").append(method.getReturnType().getName()).append(" x = ").append(method.getName()).append("_(r, mq");
        JaninoRelMetadataProvider.argList(buff, method).append(");\n").append("      mq.map.put(r, key, ").append(NullSentinel.class.getName()).append(".mask(x));\n").append("      return x;\n").append("    } catch (").append(Exception.class.getName()).append(" e) {\n").append("      mq.map.row(r).clear();\n").append("      throw e;\n").append("    }\n").append("  }\n").append("\n");
    }

    private static String simpleNameForHandler(Class<? extends MetadataHandler<?>> clazz) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.equals("Handler")) {
            String[] parts = clazz.getName().split("\\.|\\$");
            return parts[parts.length - 2] + parts[parts.length - 1];
        }
        return simpleName;
    }

    private static StringBuilder argList(StringBuilder buff, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 2; i < paramTypes.length; ++i) {
            buff.append(", a").append(i - 2);
        }
        return buff;
    }

    private static StringBuilder safeArgList(StringBuilder buff, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 2; i < paramTypes.length; ++i) {
            Class<?> t2 = paramTypes[i];
            if (Primitive.is(t2)) {
                buff.append(", a").append(i - 2);
                continue;
            }
            buff.append(", ").append(NullSentinel.class.getName()).append(".mask(a").append(i - 2).append(")");
        }
        return buff;
    }

    private static StringBuilder paramList(StringBuilder buff, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 2; i < paramTypes.length; ++i) {
            buff.append(",\n      ").append(paramTypes[i].getName()).append(" a").append(i - 2);
        }
        return buff;
    }

    static <MH extends MetadataHandler<?>> MH compile(String className, String classBody, Class<MH> handlerClass, List<Object> argList) throws CompileException, IOException {
        Object o;
        ICompilerFactory compilerFactory;
        ClassLoader classLoader = Objects.requireNonNull(JaninoRelMetadataProvider.class.getClassLoader(), "classLoader");
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory(classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        ISimpleCompiler compiler = compilerFactory.newSimpleCompiler();
        compiler.setParentClassLoader(JaninoRexCompiler.class.getClassLoader());
        String s2 = "public final class " + className + " implements " + handlerClass.getCanonicalName() + " {\n" + classBody + "\n}";
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            compiler.setDebuggingInformation(true, true, true);
            System.out.println(s2);
        }
        compiler.cook(s2);
        try {
            Constructor<?> constructor = compiler.getClassLoader().loadClass(className).getDeclaredConstructors()[0];
            o = constructor.newInstance(argList.toArray());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return (MH)((MetadataHandler)handlerClass.cast(o));
    }

    synchronized <H extends MetadataHandler<?>> H revise(Class<H> handlerClass) {
        try {
            Key key = new Key(handlerClass, this.provider);
            return (H)((MetadataHandler)handlerClass.cast(HANDLERS.get(key)));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw Util.throwAsRuntime(Util.causeOrSelf(e));
        }
    }

    @Deprecated
    public void register(Iterable<Class<? extends RelNode>> classes) {
    }

    private static class Key {
        final Class<? extends MetadataHandler<? extends Metadata>> handlerClass;
        final RelMetadataProvider provider;

        private Key(Class<? extends MetadataHandler<?>> handlerClass, RelMetadataProvider provider) {
            this.handlerClass = handlerClass;
            this.provider = provider;
        }

        public int hashCode() {
            return (this.handlerClass.hashCode() * 37 + this.provider.hashCode()) * 37;
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Key && ((Key)obj).handlerClass.equals(this.handlerClass) && ((Key)obj).provider.equals(this.provider);
        }
    }

    public static class NoHandler
    extends ControlFlowException {
        public final Class<? extends RelNode> relClass;

        public NoHandler(Class<? extends RelNode> relClass) {
            this.relClass = relClass;
        }
    }
}

