/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.org.apache.calcite.materialize.Lattice;
import com.hazelcast.org.apache.calcite.materialize.TileKey;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptLattice;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.plan.ViewExpanders;
import com.hazelcast.org.apache.calcite.prepare.RelOptTableImpl;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableAggregateStarTableRule;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.schema.Table;
import com.hazelcast.org.apache.calcite.schema.impl.StarTable;
import com.hazelcast.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.mapping.AbstractSourceMapping;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Enclosing
public class AggregateStarTableRule
extends RelRule<Config>
implements TransformationRule {
    protected AggregateStarTableRule(Config config) {
        super(config);
    }

    @Deprecated
    public AggregateStarTableRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        StarTable.StarTableScan scan = (StarTable.StarTableScan)call.rel(1);
        this.apply(call, null, aggregate, scan);
    }

    protected void apply(RelOptRuleCall call, @Nullable Project postProject, final Aggregate aggregate, StarTable.StarTableScan scan) {
        RelOptPlanner planner = call.getPlanner();
        Optional<CalciteConnectionConfig> config = planner.getContext().maybeUnwrap(CalciteConnectionConfig.class);
        if (!config.isPresent() || !config.get().createMaterializations()) {
            return;
        }
        RelOptCluster cluster = scan.getCluster();
        RelOptTable table = scan.getTable();
        RelOptLattice lattice = Objects.requireNonNull(planner.getLattice(table), () -> "planner.getLattice(table) is null for " + table);
        final List<Lattice.Measure> measures = lattice.lattice.toMeasures(aggregate.getAggCallList());
        Pair<CalciteSchema.TableEntry, TileKey> pair = lattice.getAggregate(planner, aggregate.getGroupSet(), measures);
        if (pair == null) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        CalciteSchema.TableEntry tableEntry = (CalciteSchema.TableEntry)pair.left;
        final TileKey tileKey = (TileKey)pair.right;
        RelMetadataQuery mq = call.getMetadataQuery();
        double rowCount = aggregate.estimateRowCount(mq);
        Table aggregateTable = tableEntry.getTable();
        RelDataType aggregateTableRowType = aggregateTable.getRowType(cluster.getTypeFactory());
        RelOptTableImpl aggregateRelOptTable = RelOptTableImpl.create(table.getRelOptSchema(), aggregateTableRowType, tableEntry, rowCount);
        relBuilder.push(aggregateRelOptTable.toRel(ViewExpanders.simpleContext(cluster)));
        if (tileKey == null) {
            if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + " (exact match)");
            }
        } else if (!tileKey.dimensions.equals(aggregate.getGroupSet())) {
            if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + ", rolling up " + tileKey.dimensions + " to " + aggregate.getGroupSet());
            }
            assert (tileKey.dimensions.contains(aggregate.getGroupSet()));
            ArrayList<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
            ImmutableBitSet.Builder groupSet = ImmutableBitSet.builder();
            Iterator<Object> iterator = aggregate.getGroupSet().iterator();
            while (iterator.hasNext()) {
                int key = iterator.next();
                groupSet.set(tileKey.dimensions.indexOf(key));
            }
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                AggregateCall copy = AggregateStarTableRule.rollUp(groupSet.cardinality(), relBuilder, aggCall, tileKey);
                if (copy == null) {
                    return;
                }
                aggCalls.add(copy);
            }
            relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), groupSet.build(), null, aggCalls));
        } else if (!tileKey.measures.equals(measures)) {
            if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + ", right granularity, but different measures " + aggregate.getAggCallList());
            }
            relBuilder.project(relBuilder.fields(new AbstractSourceMapping(tileKey.dimensions.cardinality() + tileKey.measures.size(), aggregate.getRowType().getFieldCount()){

                @Override
                public int getSourceOpt(int source) {
                    if (source < aggregate.getGroupCount()) {
                        int in = tileKey.dimensions.nth(source);
                        return aggregate.getGroupSet().indexOf(in);
                    }
                    Lattice.Measure measure = (Lattice.Measure)measures.get(source - aggregate.getGroupCount());
                    int i = tileKey.measures.indexOf(measure);
                    assert (i >= 0);
                    return tileKey.dimensions.cardinality() + i;
                }
            }.inverse()));
        }
        if (postProject != null) {
            relBuilder.push(postProject.copy(postProject.getTraitSet(), ImmutableList.of(relBuilder.peek())));
        }
        call.transformTo(relBuilder.build());
    }

    private static @Nullable AggregateCall rollUp(int groupCount, RelBuilder relBuilder, AggregateCall aggregateCall, TileKey tileKey) {
        block4: {
            SqlAggFunction roll;
            if (aggregateCall.isDistinct()) {
                return null;
            }
            SqlAggFunction aggregation = aggregateCall.getAggregation();
            Pair<SqlAggFunction, List<Integer>> seek = Pair.of(aggregation, aggregateCall.getArgList());
            int offset = tileKey.dimensions.cardinality();
            ImmutableList<Lattice.Measure> measures = tileKey.measures;
            int i = AggregateStarTableRule.find(measures, seek);
            if (i >= 0 && (roll = aggregation.getRollup()) != null) {
                return AggregateCall.create(roll, false, aggregateCall.isApproximate(), aggregateCall.ignoreNulls(), ImmutableList.of(Integer.valueOf(offset + i)), -1, aggregateCall.distinctKeys, aggregateCall.collation, groupCount, relBuilder.peek(), null, aggregateCall.name);
            }
            ArrayList<Integer> newArgs = new ArrayList<Integer>();
            for (Integer arg : aggregateCall.getArgList()) {
                int z = tileKey.dimensions.indexOf(arg);
                if (z >= 0) {
                    newArgs.add(z);
                    continue;
                }
                break block4;
            }
            return AggregateCall.create(aggregation, false, aggregateCall.isApproximate(), aggregateCall.ignoreNulls(), newArgs, -1, aggregateCall.distinctKeys, aggregateCall.collation, groupCount, relBuilder.peek(), null, aggregateCall.name);
        }
        return null;
    }

    private static int find(ImmutableList<Lattice.Measure> measures, Pair<SqlAggFunction, List<Integer>> seek) {
        for (int i = 0; i < measures.size(); ++i) {
            Lattice.Measure measure = (Lattice.Measure)measures.get(i);
            if (!measure.agg.equals(seek.left) || !measure.argOrdinals().equals(seek.right)) continue;
            return i;
        }
        return -1;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateStarTableRule.Config.of().withOperandFor(Aggregate.class, StarTable.StarTableScan.class);

        @Override
        default public AggregateStarTableRule toRule() {
            return new AggregateStarTableRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass, Class<StarTable.StarTableScan> scanClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).predicate(Aggregate::isSimple).oneInput(b1 -> b1.operand(scanClass).noInputs())).as(Config.class);
        }
    }
}

