/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableCoerceInputsRule;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.ImmutableBeans;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
public class CoerceInputsRule
extends RelRule<Config>
implements TransformationRule {
    protected CoerceInputsRule(Config config) {
        super(config);
    }

    @Deprecated
    public CoerceInputsRule(Class<? extends RelNode> consumerRelClass, boolean coerceNames) {
        this(Config.DEFAULT.withCoerceNames(coerceNames).withOperandFor(consumerRelClass));
    }

    @Deprecated
    public CoerceInputsRule(Class<? extends RelNode> consumerRelClass, boolean coerceNames, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withCoerceNames(coerceNames).withConsumerRelClass(consumerRelClass));
    }

    @Override
    public @Nullable Convention getOutConvention() {
        return Convention.NONE;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object consumerRel = call.rel(0);
        if (consumerRel.getClass() != ((Config)this.config).consumerRelClass()) {
            return;
        }
        List<RelNode> inputs = consumerRel.getInputs();
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(inputs);
        boolean coerce = false;
        for (int i = 0; i < inputs.size(); ++i) {
            RelDataType expectedType = consumerRel.getExpectedInputRowType(i);
            RelNode input = inputs.get(i);
            RelNode newInput = RelOptUtil.createCastRel(input, expectedType, ((Config)this.config).isCoerceNames());
            if (newInput != input) {
                newInputs.set(i, newInput);
                coerce = true;
            }
            assert (RelOptUtil.areRowTypesEqual(((RelNode)newInputs.get(i)).getRowType(), expectedType, ((Config)this.config).isCoerceNames()));
        }
        if (!coerce) {
            return;
        }
        RelNode newConsumerRel = consumerRel.copy(consumerRel.getTraitSet(), newInputs);
        call.transformTo(newConsumerRel);
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableCoerceInputsRule.Config.builder().withConsumerRelClass(RelNode.class).build().withCoerceNames(false).withOperandFor(RelNode.class);

        @Override
        default public CoerceInputsRule toRule() {
            return new CoerceInputsRule(this);
        }

        @ImmutableBeans.Property
        @ImmutableBeans.BooleanDefault(value=false)
        @Value.Default
        default public boolean isCoerceNames() {
            return false;
        }

        public Config withCoerceNames(boolean var1);

        @ImmutableBeans.Property
        public Class<? extends RelNode> consumerRelClass();

        public Config withConsumerRelClass(Class<? extends RelNode> var1);

        default public Config withOperandFor(Class<? extends RelNode> consumerRelClass) {
            return this.withConsumerRelClass(consumerRelClass).withOperandSupplier(b -> b.operand(consumerRelClass).anyInputs()).withDescription("CoerceInputsRule:" + consumerRelClass.getName()).as(Config.class);
        }
    }
}

