/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.dialect;

import com.hazelcast.org.apache.calcite.avatica.util.TimeUnitRange;
import com.hazelcast.org.apache.calcite.config.NullCollation;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlBasicTypeNameSpec;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.org.apache.calcite.sql.SqlDateLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlTimeLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlTimestampLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.BasicSqlType;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.RelToSqlConverterUtil;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public class ClickHouseSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.CLICKHOUSE).withIdentifierQuoteString("`").withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new ClickHouseSqlDialect(DEFAULT_CONTEXT);

    public ClickHouseSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return false;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public SqlDialect.CalendarPolicy getCalendarPolicy() {
        return SqlDialect.CalendarPolicy.SHIFT;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            SqlTypeName typeName = type.getSqlTypeName();
            switch (typeName) {
                case VARCHAR: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("String", typeName);
                }
                case TINYINT: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Int8", typeName);
                }
                case SMALLINT: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Int16", typeName);
                }
                case INTEGER: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Int32", typeName);
                }
                case BIGINT: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Int64", typeName);
                }
                case FLOAT: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Float32", typeName);
                }
                case DOUBLE: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Float64", typeName);
                }
                case DATE: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Date", typeName);
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("DateTime", typeName);
                }
            }
        }
        return super.getCastSpec(type);
    }

    private static SqlDataTypeSpec createSqlDataTypeSpecByName(final String typeAlias, SqlTypeName typeName) {
        SqlBasicTypeNameSpec spec = new SqlBasicTypeNameSpec(typeName, SqlParserPos.ZERO){

            @Override
            public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
                writer.identifier(typeAlias, true);
            }
        };
        return new SqlDataTypeSpec(spec, SqlParserPos.ZERO);
    }

    @Override
    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        String toFunc;
        if (literal instanceof SqlDateLiteral) {
            toFunc = "toDate";
        } else if (literal instanceof SqlTimestampLiteral) {
            toFunc = "toDateTime";
        } else if (literal instanceof SqlTimeLiteral) {
            toFunc = "toTime";
        } else {
            throw new RuntimeException("ClickHouse does not support DateTime literal: " + literal);
        }
        writer.literal(toFunc + "('" + literal.toFormattedString() + "')");
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        Objects.requireNonNull(fetch, "fetch");
        writer.newlineAndIndent();
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FETCH);
        writer.keyword("LIMIT");
        if (offset != null) {
            offset.unparse(writer, -1, -1);
            writer.sep(",", true);
        }
        fetch.unparse(writer, -1, -1);
        writer.endList(frame);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            RelToSqlConverterUtil.specialOperatorByName("substring").unparse(writer, call, 0, 0);
        } else {
            switch (call.getKind()) {
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    ClickHouseSqlDialect.unparseFloor(writer, call);
                    break;
                }
                case COUNT: {
                    if (call.getFunctionQuantifier() != null && call.getFunctionQuantifier().toString().equals("DISTINCT")) {
                        writer.print("assumeNotNull");
                        SqlWriter.Frame frame = writer.startList("(", ")");
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        writer.endList(frame);
                        break;
                    }
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }

    private static void unparseFloor(SqlWriter writer, SqlCall call) {
        String funName;
        SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = timeUnitNode.getValueAs(TimeUnitRange.class);
        switch (unit) {
            case YEAR: {
                funName = "toStartOfYear";
                break;
            }
            case MONTH: {
                funName = "toStartOfMonth";
                break;
            }
            case WEEK: {
                funName = "toMonday";
                break;
            }
            case DAY: {
                funName = "toDate";
                break;
            }
            case HOUR: {
                funName = "toStartOfHour";
                break;
            }
            case MINUTE: {
                funName = "toStartOfMinute";
                break;
            }
            default: {
                throw new RuntimeException("ClickHouse does not support FLOOR for time unit: " + (Object)((Object)unit));
            }
        }
        writer.print(funName);
        SqlWriter.Frame frame = writer.startList("(", ")");
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.endList(frame);
    }
}

