/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.dialect;

import com.hazelcast.com.google.common.collect.ImmutableCollection;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.ImmutableSetMultimap;
import com.hazelcast.com.google.common.collect.Multimap;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.org.slf4j.Logger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class JethroDataSqlDialect
extends SqlDialect {
    private final JethroInfo info;

    public JethroDataSqlDialect(SqlDialect.Context context) {
        super(context);
        this.info = context.jethroInfo();
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return node;
    }

    @Override
    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case COUNT: 
            case SUM: 
            case AVG: 
            case MIN: 
            case MAX: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsFunction(SqlOperator operator, RelDataType type, List<RelDataType> paramTypes) {
        switch (operator.getKind()) {
            case IS_NOT_NULL: 
            case IS_NULL: 
            case AND: 
            case OR: 
            case NOT: 
            case BETWEEN: 
            case CASE: 
            case CAST: {
                return true;
            }
        }
        ImmutableCollection functions = this.info.supportedFunctions.get(operator.getName());
        if (functions != null) {
            for (JethroSupportedFunction f : functions) {
                if (!f.argumentsMatch(paramTypes)) continue;
                return true;
            }
        }
        LOGGER.debug("Unsupported function in jethro: " + operator + " with params " + paramTypes);
        return false;
    }

    @Override
    public boolean supportsOffsetFetch() {
        return false;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    public static JethroInfoCache createCache() {
        return new JethroInfoCacheImpl();
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    public static class JethroInfo {
        public static final JethroInfo EMPTY = new JethroInfo(ImmutableSetMultimap.of());
        private final ImmutableSetMultimap<String, JethroSupportedFunction> supportedFunctions;

        public JethroInfo(Multimap<String, JethroSupportedFunction> supportedFunctions) {
            this.supportedFunctions = ImmutableSetMultimap.copyOf(supportedFunctions);
        }
    }

    private static class JethroInfoCacheImpl
    implements JethroInfoCache {
        final Map<String, JethroInfo> map = new HashMap<String, JethroInfo>();

        private JethroInfoCacheImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JethroInfo get(DatabaseMetaData metaData) {
            try {
                assert ("JethroData".equals(metaData.getDatabaseProductName()));
                String productVersion = metaData.getDatabaseProductVersion();
                JethroInfoCacheImpl jethroInfoCacheImpl = this;
                synchronized (jethroInfoCacheImpl) {
                    JethroInfo info = this.map.get(productVersion);
                    if (info == null) {
                        Connection c = metaData.getConnection();
                        info = JethroInfoCacheImpl.makeInfo(c);
                        this.map.put(productVersion, info);
                    }
                    return info;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to create JethroDataDialect", e);
                throw new RuntimeException("Failed to create JethroDataDialect", e);
            }
        }

        /*
         * Exception decompiling
         */
        private static JethroInfo makeInfo(Connection jethroConnection) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ String lambda$makeInfo$0(String functionName) {
            return "operands for " + functionName;
        }
    }

    public static interface JethroInfoCache {
        public JethroInfo get(DatabaseMetaData var1);
    }

    static class JethroSupportedFunction {
        private final List<SqlTypeName> operandTypes;

        JethroSupportedFunction(String name, String operands) {
            Objects.requireNonNull(name, "name");
            ImmutableList.Builder b = ImmutableList.builder();
            for (String strType : operands.split(":")) {
                b.add((Object)JethroSupportedFunction.parse(strType));
            }
            this.operandTypes = b.build();
        }

        private static SqlTypeName parse(String strType) {
            switch (strType.toLowerCase(Locale.ROOT)) {
                case "bigint": 
                case "long": {
                    return SqlTypeName.BIGINT;
                }
                case "integer": 
                case "int": {
                    return SqlTypeName.INTEGER;
                }
                case "double": {
                    return SqlTypeName.DOUBLE;
                }
                case "float": {
                    return SqlTypeName.FLOAT;
                }
                case "string": {
                    return SqlTypeName.VARCHAR;
                }
                case "timestamp": {
                    return SqlTypeName.TIMESTAMP;
                }
            }
            return SqlTypeName.ANY;
        }

        boolean argumentsMatch(List<RelDataType> paramTypes) {
            if (paramTypes.size() != this.operandTypes.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.size(); ++i) {
                if (paramTypes.get(i).getSqlTypeName() == this.operandTypes.get(i)) continue;
                return false;
            }
            return true;
        }
    }
}

