/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.com.google.common.collect.ImmutableSetMultimap;
import com.hazelcast.com.google.common.collect.SetMultimap;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.type.InferTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.util.Static;
import java.text.Collator;
import java.util.Objects;

public class SqlCastFunction
extends SqlFunction {
    private final SetMultimap<SqlTypeFamily, SqlTypeFamily> nonMonotonicCasts = ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().put(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.APPROXIMATE_NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.EXACT_NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.APPROXIMATE_NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.DATETIME_INTERVAL)).put(SqlTypeFamily.DATETIME, SqlTypeFamily.TIME)).put(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIME)).put(SqlTypeFamily.TIME, SqlTypeFamily.DATETIME)).put(SqlTypeFamily.TIME, SqlTypeFamily.TIMESTAMP)).build();

    public SqlCastFunction() {
        super("CAST", SqlKind.CAST, null, InferTypes.FIRST_KNOWN, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        SqlCallBinding callBinding;
        SqlNode operand0;
        assert (opBinding.getOperandCount() == 2);
        RelDataType ret = opBinding.getOperandType(1);
        RelDataType firstType = opBinding.getOperandType(0);
        ret = opBinding.getTypeFactory().createTypeWithNullability(ret, firstType.isNullable());
        if (opBinding instanceof SqlCallBinding && (SqlUtil.isNullLiteral(operand0 = (callBinding = (SqlCallBinding)opBinding).operand(0), false) || operand0 instanceof SqlDynamicParam)) {
            SqlValidatorImpl validator = (SqlValidatorImpl)callBinding.getValidator();
            validator.setValidatedNodeType(operand0, ret);
        }
        return ret;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 2);
        return "{0}({1} AS {2})";
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        if (SqlUtil.isNullLiteral(left, false) || left instanceof SqlDynamicParam) {
            return true;
        }
        RelDataType validatedNodeType = callBinding.getValidator().getValidatedNodeType(left);
        RelDataType returnType = SqlTypeUtil.deriveType(callBinding, right);
        if (!SqlTypeUtil.canCastFrom(returnType, validatedNodeType, true)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.toString(), returnType.toString()));
            }
            return false;
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(validatedNodeType, returnType)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.getFullTypeString(), returnType.getFullTypeString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep("AS");
        if (call.operand(1) instanceof SqlIntervalQualifier) {
            writer.sep("INTERVAL");
        }
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        Collator castToCollator;
        RelDataType castFromType = call.getOperandType(0);
        RelDataTypeFamily castFromFamily = castFromType.getFamily();
        Collator castFromCollator = castFromType.getCollation() == null ? null : castFromType.getCollation().getCollator();
        RelDataType castToType = call.getOperandType(1);
        RelDataTypeFamily castToFamily = castToType.getFamily();
        Collator collator = castToCollator = castToType.getCollation() == null ? null : castToType.getCollation().getCollator();
        if (!Objects.equals(castFromCollator, castToCollator)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (castFromFamily instanceof SqlTypeFamily && castToFamily instanceof SqlTypeFamily && this.nonMonotonicCasts.containsEntry(castFromFamily, castToFamily)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return call.getOperandMonotonicity(0);
    }
}

