/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNonNullableAccessors;

public class SqlTimestampAddFunction
extends SqlFunction {
    private static final int MILLISECOND_PRECISION = 3;
    private static final int MICROSECOND_PRECISION = 6;
    private static final SqlReturnTypeInference RETURN_TYPE_INFERENCE = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return SqlTimestampAddFunction.deduceType(typeFactory, SqlNonNullableAccessors.getOperandLiteralValueOrThrow(opBinding, 0, TimeUnit.class), opBinding.getOperandType(1), opBinding.getOperandType(2));
    };

    public static RelDataType deduceType(RelDataTypeFactory typeFactory, TimeUnit timeUnit, RelDataType operandType1, RelDataType operandType2) {
        RelDataType type;
        block0 : switch (timeUnit) {
            case MILLISECOND: 
            case MICROSECOND: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                switch (timeUnit) {
                    case MILLISECOND: {
                        type = typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 3);
                        break block0;
                    }
                    case MICROSECOND: {
                        type = typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 6);
                        break block0;
                    }
                }
                if (operandType2.getSqlTypeName() == SqlTypeName.TIME) {
                    type = typeFactory.createSqlType(SqlTypeName.TIME);
                    break;
                }
                type = typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
                break;
            }
            default: {
                type = operandType2;
            }
        }
        return typeFactory.createTypeWithNullability(type, operandType1.isNullable() || operandType2.isNullable());
    }

    SqlTimestampAddFunction() {
        super("TIMESTAMPADD", SqlKind.TIMESTAMP_ADD, RETURN_TYPE_INFERENCE, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
    }
}

