/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.type.SameOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SameOperandTypeExceptLastOperandChecker
extends SameOperandTypeChecker {
    protected final String lastOperandTypeName;

    public SameOperandTypeExceptLastOperandChecker(int nOperands, String lastOperandTypeName) {
        super(nOperands);
        this.lastOperandTypeName = lastOperandTypeName;
    }

    @Override
    protected boolean checkOperandTypesImpl(SqlOperatorBinding operatorBinding, boolean throwOnFailure, @Nullable SqlCallBinding callBinding) {
        if (throwOnFailure && callBinding == null) {
            throw new IllegalArgumentException("callBinding must be non-null in case throwOnFailure=true");
        }
        int nOperandsActual = this.nOperands;
        if (nOperandsActual == -1) {
            nOperandsActual = operatorBinding.getOperandCount();
        }
        RelDataType[] types = new RelDataType[nOperandsActual];
        List<Integer> operandList = this.getOperandList(operatorBinding.getOperandCount());
        for (int i : operandList) {
            if (operatorBinding.isOperandNull(i, false)) {
                if (Objects.requireNonNull(callBinding, "callBinding").isTypeCoercionEnabled()) {
                    types[i] = operatorBinding.getTypeFactory().createSqlType(SqlTypeName.NULL);
                    continue;
                }
                if (throwOnFailure) {
                    throw callBinding.getValidator().newValidationError(callBinding.operand(i), Static.RESOURCE.nullIllegal());
                }
                return false;
            }
            types[i] = operatorBinding.getOperandType(i);
        }
        int prev = -1;
        for (int i : operandList) {
            if (prev >= 0 && i != operandList.get(operandList.size() - 1) && !SqlTypeUtil.isComparable(types[i], types[prev])) {
                if (!throwOnFailure) {
                    return false;
                }
                throw Objects.requireNonNull(callBinding, "callBinding").newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            prev = i;
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        String typeName = this.getTypeName();
        if (this.nOperands == -1) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of(typeName, typeName, "..."));
        }
        List<String> types = Collections.nCopies(this.nOperands - 1, typeName);
        types.add(this.lastOperandTypeName);
        return SqlUtil.getAliasedSignature(op, opName, types);
    }
}

