/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.util;

import com.hazelcast.com.google.common.base.Suppliers;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.prepare.CalciteCatalogReader;
import com.hazelcast.org.apache.calcite.runtime.GeoFunctions;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.fun.SqlGeoFunctions;
import com.hazelcast.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;
import java.util.function.Supplier;

public class SqlOperatorTables
extends ReflectiveSqlOperatorTable {
    private static final Supplier<SqlOperatorTable> SPATIAL = Suppliers.memoize(SqlOperatorTables::createSpatial)::get;

    private static SqlOperatorTable createSpatial() {
        return CalciteCatalogReader.operatorTable(GeoFunctions.class.getName(), SqlGeoFunctions.class.getName());
    }

    public static SqlOperatorTable spatialInstance() {
        return SPATIAL.get();
    }

    public static SqlOperatorTable chain(Iterable<SqlOperatorTable> tables) {
        ImmutableList<SqlOperatorTable> list = ImmutableList.copyOf(tables);
        if (list.size() == 1) {
            return (SqlOperatorTable)list.get(0);
        }
        return new ChainedSqlOperatorTable(list);
    }

    public static SqlOperatorTable chain(SqlOperatorTable ... tables) {
        return SqlOperatorTables.chain(ImmutableList.copyOf(tables));
    }
}

